/***************************************************************************
 *   Copyright (C) 2005 by Roland Weigert   *
 *   roweigert@t-online.de   *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/
#include "oggenc-encoder.h"

oggencengine::oggencengine(QString source,QString destination,mediatag Song,progressmainwindow *progresswindow)
{
    //split up the options into a stringlist
    QStringList optionslist;
    QString buffer=settingsfile.oggencoptions;
    buffer=buffer.remove(' ');
    while(!buffer.isEmpty())
    {
        if (buffer.startsWith("-"))
        {
            //this is the right thing, so we can copy all up to the next - or till the end into the stringlist
            QString newparameter;
            if (buffer.contains('-')>1)
            {
                int position=buffer.find('-',1);
                newparameter=buffer.left(position);
                buffer=buffer.remove(newparameter);
            }
            else
            {
                newparameter=buffer;
                buffer=QString::null;
            }
            optionslist.append(newparameter);
        }
        else
        {
            //try to find a -, and set complete buffer to null
            if (!buffer.contains('-'))
                buffer=QString::null;
            else
            {
                int position=buffer.find('-');
                buffer=buffer.right(buffer.length()-(position+1));
            }
        }
    }
  Songtags=Song;
  wavfile=source;
  mp3file=destination;
  KProcess *oggencProcess=new KProcess;
  progress=progresswindow->startProgress(QString(i18n("encoding track %1 with oggenc")).arg(QString::number(Song.number)),100,oggencProcess);
  progresswindow->show();
    *oggencProcess<<settingsfile.oggencexe;
    QStringList::Iterator parameters=optionslist.begin();
    while(parameters!=optionslist.end())
    {
        *oggencProcess<<*parameters;
        parameters++;
    }
    if (settingsfile.oggencvbr)
        *oggencProcess<<"--managed"<<QString("-b%1").arg(QString::number(settingsfile.oggencbitrate))<<source<<"-o"<<destination;
    else
        *oggencProcess<<QString("-b%1").arg(QString::number(settingsfile.oggencbitrate))<<source<<"-o"<<destination;
  connect(oggencProcess,SIGNAL(receivedStderr(KProcess *,char *,int)),SLOT(readprogressinfo(KProcess *,char *,int)));
  connect(oggencProcess,SIGNAL(processExited(KProcess *)),SLOT(finishedProcess(KProcess *)));
  connect(this,SIGNAL(killProgress(progresswithbar *)),progresswindow,SLOT(killProgress(progresswithbar *)));
  oggencProcess->start(KProcess::RunMode(1),KProcess::Communication(6));
}

void oggencengine::readprogressinfo(KProcess  *proc,char *text,int length)
{
    QString buffer=text;
    int percent=0;
    if (buffer.contains('['))
    {
        QString line=buffer.left(buffer.find('%')-2);
        line=line.remove(0,line.find('[')+1);
        line.stripWhiteSpace();
        percent=line.toInt();
    }
    progress->setProgress(percent);
}

void oggencengine::finishedProcess(KProcess *proc)
{
  disconnect(proc,SIGNAL(receivedStderr(KProcess *,char *,int)),this,SLOT(readprogressinfo(KProcess *,char *,int)));
  disconnect(proc,SIGNAL(processExited(KProcess *)),this,SLOT(finishedProcess(KProcess *)));
  emit killProgress(progress);
  QFile wav(wavfile);
  wav.remove();
  mediafile file(mp3file);
  if (file.readsuccess)
  {
    file.setTags(Songtags);
    file.saveFile();
  }
}

