/***************************************************************************
 *   Copyright (C) 2005 by Roland Weigert   *
 *   roweigert@t-online.de   *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/
#ifndef _MUSICBRAINZINTERFACE_H
#define _MUSICBRAINZINTERFACE_H

using namespace std;

#include <qhttp.h>
#include <qstring.h>
#include <qptrlist.h>
#include <qstring.h>
#include <qdom.h>
#include <klocale.h>
#include <kapp.h>

#include "mediatag.h"
#include "databasewrapper.h"
#include "rcdatei.h"

#include <iostream>

class databasewrapper;

extern databasewrapper *database;
extern rcdatei settingsfile;

struct musicbrainzartist;
struct musicbrainztrack;
class musicbrainzalbum;

//Motherclass for music-brainz-support
class musicbrainzconnect : public QObject
{
    Q_OBJECT
public:
    musicbrainzconnect();
    ~musicbrainzconnect();
    bool findsong(mediatag *);
private:
    QHttp *url;
    bool queryOk;
    int transactionid;
    bool notfinished;
    QByteArray musicbrainzquery(QString);
    bool checkdouble(QString);
    QPtrList<musicbrainzalbum> *fetchedalbums;
    //all the findfunctions needed to find with given input
    bool TitleOnly(mediatag *);
    bool TitleNumber(mediatag *);
    bool TitleNumberArtist(mediatag *,int);
    bool AlbumOnly(mediatag *,int);
    bool ArtistAlbum(mediatag *,int);
    bool NumberAlbum(mediatag *,int);
    bool NumberArtist(mediatag *,int);
    bool NumberArtistAlbum(mediatag *,int);
    bool TitleAlbum(mediatag *,int);
    bool TitleArtist(mediatag *,int);
    bool TitleArtistAlbum(mediatag *,int);
    bool TitleNumberAlbum(mediatag *,int);
    bool Releasdatemissing(mediatag *,int);
    //all parsing-functions for the xml-results from musicbrainz
    QPtrList<musicbrainzartist> parseartists(QByteArray);
    QPtrList<musicbrainzalbum> parsealbumsfromartist(QByteArray);
    int parsetracksfromalbum(QByteArray,musicbrainzalbum *);
    QPtrList<musicbrainzalbum> parsealbums(QByteArray);
    QPtrList<musicbrainzalbum> parsetracks(QByteArray);
    QStringList querystrings;
private slots:
    void getfinished(int,bool);
};

struct musicbrainzartist
{
    QString artistid;
    QString artistname;
};

struct musicbrainztrack
{
    QString musicbrainztrackid;
    QString trackname;
    long duration;
    int tracknumber;
};

//This class can hold complete albums from musicbrainz, They are generated by the parsealbums and parsetracks
class musicbrainzalbum
{
public:
    musicbrainzalbum ();
    ~musicbrainzalbum();
    void copy(musicbrainzalbum *);
    QString musicbrainzalbumid;
    QString musicbrainzartistid;
    QString artistname;
    QString albumname;
    int releasedate;
    QPtrList<musicbrainztrack> tracklist;
};

#endif //_MUSICBRAINZINTERFACE_H
