/***************************************************************************
 *   Copyright (C) 2005 by Roland Weigert   *
 *   roweigert@t-online.de   *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/

#include "fileoperations.h"


//returns -1 if input could not be opened
//returns -2 if output could not be opened
//returns -3 if filesizes doesnt match after copy
//returns 1 if everything went ok
int copyfile(QString source,QString destination)
{
    cerr<<"source: "<<source<<"   destination: "<<destination<<endl;
    int success=0;
    QFile sourcefile(source);
    QFile destinationfile(destination);
    if(sourcefile.open(IO_ReadOnly))
    {
        if (destinationfile.open(IO_WriteOnly))
        {
            QDataStream inputfile(&sourcefile);
            QDataStream outputfile(&destinationfile);
            const int buffersize=1024;
            char buffer[buffersize];
            long filesize=sourcefile.size();
            long endoffset=filesize/buffersize;
            //lets see if we need to read one smaller block at end
            if ((endoffset*buffersize)==filesize)
            {
                while(!inputfile.atEnd())
                {
                    inputfile.readRawBytes(buffer,buffersize);
                    outputfile.writeRawBytes(buffer,buffersize);
                }
            }
            else
            {
                int endbuffer=filesize-(endoffset*buffersize);
                if (filesize)
                {
                    for (int i=0;i<endoffset;i++)
                    {
                        inputfile.readRawBytes(buffer,buffersize);
                        outputfile.writeRawBytes(buffer,buffersize);
                    }
                    inputfile.readRawBytes(buffer,endbuffer);
                    outputfile.writeRawBytes(buffer,endbuffer);
                }
            }
            destinationfile.close();
            if(sourcefile.size()==destinationfile.size())
                success=1;
            else
                success=-3;
        }
        else
            success=-2;
        sourcefile.close();
    }
    else
    {
        success=-1;
    }
    cerr<<"this is the result of the copyoperation for "<<source<<" to "<<destination<<"  :"<<success<<endl;
    return success;
}

//returns -1 if input could not be opened
//returns -2 if output could not be written
//returns 1 if everything went ok

int renamefile(QString oldname,QString newname)
{
int success=0;
}
