/***************************************************************************
 *   Copyright (C) 2005 by Roland Weigert   *
 *   roweigert@t-online.de   *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/

#ifndef _DATABASEWRAPPER_H_
#define _DATABASEWRAPPER_H_

#include <qstring.h>
#include <qcombobox.h>
#include <mediatag.h>

#include "musicbrainz-interface.h"
#include "mysqlinterface.h"
#include "rcdatei.h"

class musicbrainzalbum;

/*This is the masterclass for all the database-support in K-Yamo
 *First supported engine is mysql, more to follow
 *Most functions only hand over the parameters to the right database-class*/

class databasewrapper
{
public:
    databasewrapper();
    ~databasewrapper();
    bool quit;
    void fillCombo(QComboBox *,QString,QString);
    void fillSortedCombo(QComboBox *,QString,QString,QString);
    void fillSortedCombo(QComboBox *,QString,QString,QString,QString);
    bool albumexists(long,long,QStringList *);
    bool checkdiscid(QString,QComboBox *,QComboBox *);
    long translateartist(QString);
    long translatealbum(QString);
    long translategenre(QString);
    QString translateartist(long);
    QString translatealbum(long);
    QString translategenre(long);
    long getyear(long);
    void gettrack(QComboBox *,long,long,int);
    void writetag(mediatag *);
    bool checkModified(QString);
    void writetag(mediatag *,QString);
    void updatetag(mediatag *,QString);
    void writealbum(QString,QString,QString,QString,long,QStringList *);
    void writealbum(musicbrainzalbum *);
    void removefile(QString);
private:
    mysqldatabase *mysqldatabaseconnect;
    //More engines here to follow
};

#endif //_DATABASEWRAPPER_H_
