/***************************************************************************
 *   Copyright (C) 2003 by Stephen Allewell                                *
 *   stephen@mirramar.fsnet.co.uk                                          *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 ***************************************************************************/

#include <qpainter.h>
#include <qpoint.h>
#include <qpaintdevicemetrics.h>
#include <kprinter.h>
#include <kdebug.h>
#include <kapplication.h>
#include <kconfig.h>
#include "kxstitchview.h"
#include "kxstitchdoc.h"
#include "kxstitch.h"
#include "preview.h"
#include "paletteview.h"
#include "editview.h"

KXStitchView::KXStitchView(QWidget *parent, const char *name)
  : QSplitter(parent, "ParentSplitter")
{
  setBackgroundMode(PaletteBase);
  QSplitter *child = new QSplitter(Vertical, this, "ChildSplitter");
  m_preview = new PreView(getDocument(),child);
  m_palette = new PaletteView(getDocument(),child);
  m_editor = new EditView(getDocument(),this);
  QValueList<int> initSizes;
  KConfig *conf = kapp->config();
  conf->setGroup("General Options");
  initSizes = conf->readIntListEntry("ChildSplitter");
  child->setSizes(initSizes);
  initSizes = conf->readIntListEntry("ParentSplitter");
  setSizes(initSizes);

/** initialise the connections between the editor, palette and preview windows */
  connect(m_preview, SIGNAL(clicked(QPoint)), m_editor, SLOT(slotSetCenter(QPoint)));
  connect(m_editor, SIGNAL(changedVisibleCells(QRect)), m_preview, SLOT(setVisibleCells(QRect)));
}

KXStitchView::~KXStitchView()
{
}

KXStitchDoc *KXStitchView::getDocument() const
{
  KXStitchApp *theApp=(KXStitchApp *) parentWidget();
  return theApp->getDocument();
}

void KXStitchView::configure()
{
  m_palette->configure();
  m_editor->configure(false);
}

void KXStitchView::resetView()
{
  m_preview->repaint(true);
  m_palette->repaint(true);
  m_editor->resizeGrid();
  m_editor->repaint(true);
  m_editor->viewport()->repaint(true);
}

void KXStitchView::print(KPrinter* printer)
{
  QPainter printPainter;
  printPainter.begin(printer);
  QPaintDeviceMetrics printerMetrics(printer);
  int width = printerMetrics.width();
  int height = printerMetrics.height();
  int pages = 0;
  int page = 0;
  if (printer->option("kde-kxstitch-frontpage") == "true")
    page = m_preview->print(printer, &printPainter, width, height, pages);
  if (printer->option("kde-kxstitch-colorkey") == "true")
  {
    if (page > pages)
    {
      printer->newPage();
      pages = page;
    }
    page = m_palette->print(printer, &printPainter, width, height, pages);
  }
  if (printer->option("kde-kxstitch-pattern") == "true")
  {
    if (page > pages)
    {
      printer->newPage();
      pages = page;
    }
    pages = m_editor->print(printer, &printPainter, width, height, pages);
  }
  printPainter.end();
}
