/***************************************************************************
 *   Copyright (C) 2006 by Tomasz Sałaciński   *
 *   distortion@vp.pl   *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/

//KDE Includes
#include <kdialog.h>
#include <klistbox.h>
#include <kpushbutton.h>
#include <kcombobox.h>
#include <knuminput.h>
#include <kiconloader.h>
#include <kprocess.h>

//QT Includes
#include <qgroupbox.h>


//kX Generator Includes
#include "Xorg.h"

class ScreenModesEditor : public KDialog
{
    Q_OBJECT
public:
ScreenModesEditor(QWidget *Parent = 0, Xorg *Xorg = 0, int SectionNumber = 0);

private:
Xorg *X;
QString Locale(int n);
QString GTFScript;
KListBox *ModesListBox;
int SectNum;

   KPushButton *CancelButton;
   KPushButton *OKButton;

   KIntSpinBox *DisplayX;
   KIntSpinBox *DisplayY;

   KIntSpinBox *HSyncFrom;
   KIntSpinBox *HSyncTo;

   KIntSpinBox *VertRefFrom;
   KIntSpinBox *VertRefTo;

  KIconLoader *Icons;

  KComboBox *NewModeCombo;
  KComboBox *NewRefreshCombo;

QGroupBox *RefreshRatesGroup;
QGroupBox *DisplaySizeGroup;

KDialog *ModeDialog;

QString FormattedMode;
QString ModeLines;

  KPushButton *AddOK;
  KPushButton *AddCancel;

KProcess *GTF;




public slots:
void RemoveMode();
void AddMode();
void AddedMode();
void Mode();
void StartGTF();
void ApplyModeLines();
void GTFReadLines(KProcess * proc, char * buffer, int buflen);


};
