/***
* Author: Juergen Heinemann http://www.hjcms.de, (C) 2007-2008
* Copyright: See COPYING file that comes with this distribution
**/

#include "qx11grabmain.h"
#include "screencombobox.h"
#include "settings.h"

#include <KDE/KMenu>
#include <KDE/KMenuBar>

QX11GrabMain::QX11GrabMain ( Settings* settings )
    : m_Settings ( settings )
{
  setObjectName ( QString::fromUtf8 ( "QX11GrabMain" ) );
  resize ( 558, 396 );

  centralwidget = new QWidget ( this );
  centralwidget->setObjectName ( QString::fromUtf8 ( "centralwidget" ) );

  verticalLayout = new QVBoxLayout ( centralwidget );
  verticalLayout->setSpacing ( 0 );
  verticalLayout->setMargin ( 5 );
  verticalLayout->setObjectName ( QString::fromUtf8 ( "verticalLayout" ) );

  gridLayout = new QGridLayout();
  gridLayout->setSpacing ( 5 );
  gridLayout->setMargin ( 2 );
  gridLayout->setObjectName ( QString::fromUtf8 ( "gridLayout" ) );

  label = new QLabel ( centralwidget );
  label->setObjectName ( QString::fromUtf8 ( "label" ) );
  label->setAlignment ( Qt::AlignRight|Qt::AlignTrailing|Qt::AlignVCenter );
  label->setIndent ( 2 );
  label->setText ( i18n ( "Format:" ) );

  gridLayout->addWidget ( label, 0, 0, 1, 1 );

  screenComboBox = new ScreenComboBox ( centralwidget );
  screenComboBox->setObjectName ( QString::fromUtf8 ( "screenComboBox" ) );

  gridLayout->addWidget ( screenComboBox, 0, 1, 1, 1 );

  label_2 = new QLabel ( centralwidget );
  label_2->setObjectName ( QString::fromUtf8 ( "label_2" ) );
  label_2->setAlignment ( Qt::AlignRight|Qt::AlignTrailing|Qt::AlignVCenter );
  label_2->setIndent ( 2 );
  label_2->setText ( i18n ( "Width:" ) );

  gridLayout->addWidget ( label_2, 1, 0, 1, 1 );

  setWidthBox = new KIntSpinBox ( centralwidget );
  setWidthBox->setObjectName ( QString::fromUtf8 ( "setWidthBox" ) );
  setWidthBox->setMinimum ( 128 );
  setWidthBox->setMaximum ( 7680 );
  setWidthBox->setSingleStep ( 2 );

  gridLayout->addWidget ( setWidthBox, 1, 1, 1, 1 );

  label_3 = new QLabel ( centralwidget );
  label_3->setObjectName ( QString::fromUtf8 ( "label_3" ) );
  label_3->setAlignment ( Qt::AlignRight|Qt::AlignTrailing|Qt::AlignVCenter );
  label_3->setIndent ( 2 );
  label_3->setText ( i18n ( "Height:" ) );

  gridLayout->addWidget ( label_3, 2, 0, 1, 1 );

  setHeightBox = new KIntSpinBox ( centralwidget );
  setHeightBox->setObjectName ( QString::fromUtf8 ( "setHeightBox" ) );
  setHeightBox->setMinimum ( 96 );
  setHeightBox->setMaximum ( 4800 );
  setHeightBox->setSingleStep ( 2 );

  gridLayout->addWidget ( setHeightBox, 2, 1, 1, 1 );

  label_4 = new QLabel ( centralwidget );
  label_4->setObjectName ( QString::fromUtf8 ( "label_4" ) );
  label_4->setAlignment ( Qt::AlignRight|Qt::AlignTrailing|Qt::AlignVCenter );
  label_4->setIndent ( 2 );
  label_4->setText ( i18n ( "Name:" ) );

  gridLayout->addWidget ( label_4, 3, 0, 1, 1 );

  setModeName = new KLineEdit ( centralwidget );
  setModeName->setObjectName ( QString::fromUtf8 ( "setModeName" ) );

  gridLayout->addWidget ( setModeName, 3, 1, 1, 1 );

  setDepthBox = new KIntSpinBox ( centralwidget );
  setDepthBox->setObjectName ( QString::fromUtf8 ( "setDepthBox" ) );
  setDepthBox->setContextMenuPolicy ( Qt::NoContextMenu );
  setDepthBox->setFrame ( false );
  setDepthBox->setReadOnly ( true );
  setDepthBox->setKeyboardTracking ( false );
  setDepthBox->setMinimum ( 8 );
  setDepthBox->setMaximum ( 36 );
  setDepthBox->setValue ( 16 );

  gridLayout->addWidget ( setDepthBox, 4, 1, 1, 1 );

  label_6 = new QLabel ( centralwidget );
  label_6->setObjectName ( QString::fromUtf8 ( "label_6" ) );
  label_6->setAlignment ( Qt::AlignRight|Qt::AlignTrailing|Qt::AlignVCenter );
  label_6->setIndent ( 2 );
  label_6->setText ( i18n ( "xPos:" ) );

  gridLayout->addWidget ( label_6, 5, 0, 1, 1 );

  setXBox = new KIntSpinBox ( centralwidget );
  setXBox->setObjectName ( QString::fromUtf8 ( "setXBox" ) );
  setXBox->setMaximum ( 7680 );

  gridLayout->addWidget ( setXBox, 5, 1, 1, 1 );

  label_7 = new QLabel ( centralwidget );
  label_7->setObjectName ( QString::fromUtf8 ( "label_7" ) );
  label_7->setAlignment ( Qt::AlignRight|Qt::AlignTrailing|Qt::AlignVCenter );
  label_7->setIndent ( 2 );
  label_7->setText ( i18n ( "yPos:" ) );

  gridLayout->addWidget ( label_7, 6, 0, 1, 1 );

  setYBox = new KIntSpinBox ( centralwidget );
  setYBox->setObjectName ( QString::fromUtf8 ( "setYBox" ) );
  setYBox->setMaximum ( 4800 );
  setYBox->setValue ( 30 );

  gridLayout->addWidget ( setYBox, 6, 1, 1, 1 );

  verticalLayout->addLayout ( gridLayout );

  showRubberband = new QCheckBox ( centralwidget );
  showRubberband->setObjectName ( QString::fromUtf8 ( "showRubberband" ) );
  showRubberband->setText ( i18n ( "Display Rubberband" ) );

  verticalLayout->addWidget ( showRubberband );

  setCentralWidget ( centralwidget );

  addWinActionMenu();

  setStatusBar ( statusBar() );
}

const KIcon QX11GrabMain::getIcon ( const QString &name, const KIconLoader::Group &group )
{
  KIcon icon;
  KIconLoader *loader = KIconLoader::global();
  QPixmap pixmap = loader->loadIcon ( name, group );
  icon.addPixmap ( pixmap, QIcon::Normal, QIcon::Off );
  return icon;
}

void QX11GrabMain::addWinActionMenu()
{
  KMenu *menuFile, *menuSettings, *menuAbout;
  KMenuBar *menubar = menuBar();

  menubar->setObjectName ( QString::fromUtf8 ( "menubar" ) );

  // MainMenu
  menuFile = new KMenu ( i18n ( "Action" ), menubar );
  menuFile->setObjectName ( QString::fromUtf8 ( "menuFile" ) );

  actionGrabbing = new KAction ( this );
  actionGrabbing->setObjectName ( QString::fromUtf8 ( "actionGrabbing" ) );
  actionGrabbing->setText ( i18n ( "Grabbing" ) );
  actionGrabbing->setIcon ( getIcon ( "edit-find", KIconLoader::Toolbar ) );
  menuFile->addAction ( actionGrabbing );

  actionStartRecord = new KAction ( this );
  actionStartRecord->setObjectName ( QString::fromUtf8 ( "actionStartRecord" ) );
  actionStartRecord->setText ( i18n ( "Recording" ) );
  actionStartRecord->setIcon ( getIcon ( "media-record", KIconLoader::Toolbar ) );
  menuFile->addAction ( actionStartRecord );

  actionStopRecord = new KAction ( this );
  actionStopRecord->setObjectName ( QString::fromUtf8 ( "actionStopRecord" ) );
  actionStopRecord->setText ( i18n ( "Stop" ) );
  actionStopRecord->setIcon ( getIcon ( "edit-clear-list", KIconLoader::Toolbar ) );
  actionStopRecord->setEnabled ( false );
  menuFile->addAction ( actionStopRecord );

  actionKillRecord = new KAction ( this );
  actionKillRecord->setObjectName ( QString::fromUtf8 ( "actionKillRecord" ) );
  actionKillRecord->setText ( i18n ( "Kill" ) );
  actionKillRecord->setIcon ( getIcon ( "edit-clear-list", KIconLoader::Toolbar ) );
  actionKillRecord->setEnabled ( false );
  menuFile->addAction ( actionKillRecord );

  menuFile->addSeparator();

  actionMinimize = new KAction ( this );
  actionMinimize->setObjectName ( QString::fromUtf8 ( "actionMinimize" ) );
  actionMinimize->setText ( i18n ( "Minimize" ) );
  actionMinimize->setIcon ( getIcon ( "view-sort-ascending", KIconLoader::Toolbar ) );
  menuFile->addAction ( actionMinimize );

  actionQuit = new KAction ( this );
  actionQuit->setObjectName ( QString::fromUtf8 ( "actionQuit" ) );
  actionQuit->setText ( i18n ( "Quit" ) );
  actionQuit->setIcon ( getIcon ( "window-close", KIconLoader::Desktop ) );
  menuFile->addAction ( actionQuit );

  menubar->addAction ( menuFile->menuAction() );

  // Settings Menu
  menuSettings = new KMenu ( i18n ( "Settings" ), menubar );
  menuSettings->setObjectName ( QString::fromUtf8 ( "menuSettings" ) );
  menubar->addAction ( menuSettings->menuAction() );

  actionApplication = new KAction ( this );
  actionApplication->setObjectName ( QString::fromUtf8 ( "actionApplication" ) );
  actionApplication->setText ( i18n ( "Application" ) );
  actionApplication->setIcon ( getIcon ( "preferences-desktop-personal", KIconLoader::Toolbar ) );
  menuSettings->addAction ( actionApplication );

  // About Menu
  QString about = i18n ( "Author: Juergen Heinemann (Undefined)\nHomepage: http://qx11grab.hjcms.de" );
  menuAbout = helpMenu ( about, true );

  menubar->addAction ( menuAbout->menuAction() );

  setMenuBar ( menubar );
}

QX11GrabMain::~QX11GrabMain()
{}
