/***************************************************************************
 *   Copyright (C) 2004 by Matthias Reif                                   *
 *   matthias.reif@informatik.tu-chemnitz.de                               *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/

#include "kwcentryurllabel.h"

/*!
    \fn KWCEntryURLLabel::KWCEntryURLLabel( const QString & inscr, QString text, QString url, KSingleTabWidget *parent, const char *name )
 */
KWCEntryURLLabel::KWCEntryURLLabel( const QString & inscr, QString text, QString url, KSingleTabWidget *parent, const char *name ) : KWCEntry( inscr, parent, name )
{
	urlLabel = new KURLLabel( parent );
	urlLabel->setText( text );
	urlLabel->setURL( url );
	urlLabel->adjustSize();
	setValueWidget( urlLabel );
	connect( urlLabel, SIGNAL( leftClickedURL( const QString & )), this, SLOT( leftClickedURLSlot( const QString & ) ) );
}


/*!
    \fn KWCEntryURLLabel::~KWCEntryURLLabel()
 */
KWCEntryURLLabel::~KWCEntryURLLabel()
{
	delete urlLabel;
}


/*!
    \fn KWCEntryURLLabel::leftClickedURLSlot(const QString &url)
 */
void KWCEntryURLLabel::leftClickedURLSlot(const QString &url)
{
	if( url.contains( '@' ) )
		KApplication::kApplication()->invokeMailer( url, "KWaveControl", "" );
	else
		KApplication::kApplication()->invokeBrowser( url );
}


#include "kwcentryurllabel.moc"
