#ifndef _KVI_STYLE_WOOD_H_INCLUDED_
#define _KVI_STYLE_WOOD_H_INCLUDED_

// =============================================================================
//
//   This file is part of the KVIrc IRC client distribution
//
//   This program is FREE software. You can redistribute it and/or
//   modify it under the terms of the GNU General Public License
//   as published by the Free Software Foundation; either version 2
//   of the License, or (at your opinion) any later version.
//
//   This program is distributed in the HOPE that it will be USEFUL,
//   but WITHOUT ANY WARRANTY; without even the implied warranty of
//   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
//   See the GNU General Public License for more details.
//
//   You should have received a copy of the GNU General Public License
//   along with this program. If not, write to the Free Software Foundation,
//   Inc, 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
//
// =============================================================================

#include <qmotifstyle.h>

class KviPushButton;

class KviWoodStyle : public QMotifStyle
{
	Q_OBJECT
public:
	KviWoodStyle();
	~KviWoodStyle();

	void polish(QPalette &pal);
	void polish(QWidget *);
	void unPolish(QWidget *);

	void drawButton(
		QPainter *p, int x, int y, int w, int h,
		const QColorGroup &g, bool sunken = FALSE, const QBrush *fill = 0
	);
	void drawBevelButton(
		QPainter *p, int x, int y, int w, int h,
		const QColorGroup &g, bool sunken = FALSE, const QBrush *fill = 0
	);
	QRect buttonRect(int x, int y, int w, int h);
	void drawButtonMask(QPainter *p, int x, int y, int w, int h);

	void drawPushButton(KviPushButton *, QPainter *);
	void drawPushButtonLabel(KviPushButton *, QPainter *);
};

#endif // _KVI_STYLE_WOOD_H_INCLUDED_
