// =============================================================================
//
//   Copyright (C) 1999-2000 Szymon Stefanek (stefanek@tin.it)
//
//   This program is FREE software. You can redistribute it and/or
//   modify it under the terms of the GNU General Public License
//   as published by the Free Software Foundation; either version 2
//   of the License, or (at your opinion) any later version.
//
//   This program is distributed in the HOPE that it will be USEFUL,
//   but WITHOUT ANY WARRANTY; without even the implied warranty of
//   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
//   See the GNU General Public License for more details.
//
//   You should have received a copy of the GNU General Public License
//   along with this program. If not, write to the Free Software Foundation,
//   Inc, 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
//
// =============================================================================

#define _KVI_DEBUG_CHECK_RANGE_
#define _KVI_DEBUG_CLASS_NAME_ "KviImageView"

#include <qimage.h>
#include <qpainter.h>
#include <qpixmap.h>

#include "kvi_image_view.h"

KviImageView::KviImageView(QWidget *parent)
	: QScrollView(parent)
{
	m_pOriginalPixmap = 0;
	m_pViewedImage    = 0;
	m_uZoom           = 100;
	resizeContents(0, 0);
}

KviImageView::~KviImageView()
{
	if( m_pViewedImage ) {
		delete m_pViewedImage;
		m_pViewedImage = 0;
	}
	if( m_pOriginalPixmap ) {
		delete m_pOriginalPixmap;
		m_pOriginalPixmap = 0;
	}
}

bool KviImageView::loadImage(const char *fName)
{
	QPixmap pix(fName);
	if( pix.isNull() ) return false;
	if( m_pOriginalPixmap ) {
		delete m_pOriginalPixmap;
		m_pOriginalPixmap = 0;
	}
	if( m_pViewedImage ) {
		delete m_pViewedImage;
		m_pViewedImage = 0;
	}
	m_pOriginalPixmap = new QPixmap(pix);
	m_pViewedImage    = new QImage();
	*m_pViewedImage   = pix;
	m_uZoom           = 100;
	resizeContents(m_pViewedImage->width(), m_pViewedImage->height());
	viewport()->update();
	return true;
}

unsigned int KviImageView::zoom()
{
	return m_uZoom;
}

void KviImageView::setZoom(unsigned int zoom)
{
	if( !m_pOriginalPixmap ) m_uZoom = 100;
	m_uZoom = zoom;
	if( zoom < 1      )m_uZoom = 1;
	if( zoom > 100000 )m_uZoom = 100000; // Enough? :)
	if( m_pViewedImage ) {
		delete m_pViewedImage;
		m_pViewedImage = 0;
	}
	m_pViewedImage = new QImage();
	*m_pViewedImage = *m_pOriginalPixmap;
	int newW = (m_pOriginalPixmap->width()  * m_uZoom) / 100;
	int newH = (m_pOriginalPixmap->height() * m_uZoom) / 100;
	*m_pViewedImage = m_pViewedImage->smoothScale(newW, newH);
	resizeContents(m_pViewedImage->width(), m_pViewedImage->height());
	viewport()->update();
}

void KviImageView::drawContents(QPainter *p, int clipx, int clipy, int clipw, int cliph)
{
	if( !m_pViewedImage ) return;
	int w = m_pViewedImage->width()  - clipx;
	int h = m_pViewedImage->height() - clipy;
	if( w > clipw ) w = clipw;
	if( h > cliph ) h = cliph;
	if( (w >= 0) && (h >= 0) )
		p->drawImage(clipx, clipy, *m_pViewedImage, clipx, clipy, w, h);
}

#include "m_kvi_image_view.moc"
