#ifndef _KVI_BIFF_MAILBOX_H_INCLUDED_
#define _KVI_BIFF_MAILBOX_H_INCLUDED_

// =============================================================================
//
//   This file is part of the KVIrc IRC client distribution
//   Authors:
//       Krzysztof Godlewski <kristoff@poczta.wprost.pl>
//       Szymon Stefanek <stefanek@tin.it>
//
//   This program is FREE software. You can redistribute it and/or
//   modify it under the terms of the GNU General Public License
//   as published by the Free Software Foundation; either version 2
//   of the License, or (at your opinion) any later version.
//
//   This program is distributed in the HOPE that it will be USEFUL,
//   but WITHOUT ANY WARRANTY; without even the implied warranty of
//   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
//   See the GNU General Public License for more details.
//
//   You should have received a copy of the GNU General Public License
//   along with this program. If not, write to the Free Software Foundation,
//   Inc, 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
//
// =============================================================================

#include <qptrlist.h>

#include "kvi_string.h"

class KviBiffMessage;

class KviBiffMailbox
{
public:
	KviBiffMailbox(
		const QString host, const QString user, const QString pass,
		unsigned int port = 110, bool auto_check = true );

	~KviBiffMailbox();

	const char *hostname() const;
	const char *username() const;
	const char *password() const;
	unsigned int port()    const;

	unsigned int messageCount();
	QPtrList<KviBiffMessage> *messageList();

	KviBiffMessage *const findMessageByUid(const char *msg) const;

	const bool autoCheck() const;

private:
	QString m_hostname;
	QString m_username;
	QString m_password;
	int     m_port;
	bool    m_autoCheck;

	QPtrList<KviBiffMessage> *m_pMessageList; // List of messages in the mailbox
};

#endif // _KVI_BIFF_MAILBOX_H_INCLUDED_
