// =============================================================================
//
//      --- kvi_topiceditor.cpp ---
//
//   This file is part of the KVIrc IRC client distribution
//   Copyright (C) 1999-2000 Szymon Stefanek (stefanek@tin.it)
//
//   This program is FREE software. You can redistribute it and/or
//   modify it under the terms of the GNU General Public License
//   as published by the Free Software Foundation; either version 2
//   of the License, or (at your opinion) any later version.
//
//   This program is distributed in the HOPE that it will be USEFUL,
//   but WITHOUT ANY WARRANTY; without even the implied warranty of
//   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
//   See the GNU General Public License for more details.
//
//   You should have received a copy of the GNU General Public License
//   along with this program. If not, write to the Free Software Foundation,
//   Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
//
// =============================================================================

#define _KVI_DEBUG_CHECK_RANGE_
#define _KVI_DEBUG_CLASS_NAME_ "KviTopicEditor"

#include "kvi_topiceditor.h"

KviTopicEditor::KviTopicEditor(QWidget *parent)
	: KviLineEdit(parent, "topic_editor")
{
	setFocusPolicy(ClickFocus);
	m_pHistory = new QPtrList<QString>;
	m_pHistory->setAutoDelete(true);
	m_iCurHistoryIdx = -1;
}

KviTopicEditor::~KviTopicEditor()
{
	if( m_pHistory ) {
		delete m_pHistory;
		m_pHistory = 0;
	}
}

void KviTopicEditor::keyPressEvent(QKeyEvent *e)
{
	QString m_szTextBuffer = KviLineEdit::text();
	QString *pHist = new QString(m_szTextBuffer);
	switch( e->key() ) {
		case Qt::Key_Up:
			if( m_pHistory->count() > 0 ) {
				if( m_iCurHistoryIdx < 0 ) {
					m_szSaveTextBuffer = m_szTextBuffer;
					m_szTextBuffer     = *(m_pHistory->at(0));
					m_iCurHistoryIdx   = 0;
				} else if( m_iCurHistoryIdx >= (int) (m_pHistory->count()-1) ) {
					m_szTextBuffer = m_szSaveTextBuffer;
					m_iCurHistoryIdx = -1;
				} else {
					m_iCurHistoryIdx++;
					m_szTextBuffer = *(m_pHistory->at(m_iCurHistoryIdx));
				}
				KviLineEdit::setText(m_szTextBuffer);
			}
			break;
		case Qt::Key_Down:
			if( m_pHistory->count() > 0 ) {
				if( m_iCurHistoryIdx < 0 ) {
					m_szSaveTextBuffer = m_szTextBuffer;
					m_szTextBuffer = *(m_pHistory->at(m_pHistory->count()-1));
					m_iCurHistoryIdx = m_pHistory->count()-1;
				} else if( m_iCurHistoryIdx == 0 ) {
					m_szTextBuffer = m_szSaveTextBuffer;
					m_iCurHistoryIdx = -1;
				} else {
					m_iCurHistoryIdx--;
					m_szTextBuffer = *(m_pHistory->at(m_iCurHistoryIdx));
				}
				KviLineEdit::setText(m_szTextBuffer);
			}
			break;
		case Qt::Key_Enter: // Fall-through
		case Qt::Key_Return:
			if( m_pHistory->count() > 0 ) {
				if( m_szTextBuffer.lower() != m_pHistory->at(0)->lower() )
					m_pHistory->insert(0, pHist);
			} else m_pHistory->insert(0, pHist);
			if( m_pHistory->count() > 10 )
				m_pHistory->removeLast();
			emit returnPressed(displayText());
			e->ignore();
			break;
		default:
			KviLineEdit::keyPressEvent(e);
			break;
	}
}

void KviTopicEditor::focusOutEvent(QFocusEvent *)
{
	hide();
}

void KviTopicEditor::connectMe(QObject *receiver, const char *slot)
{
	disconnect(this, SIGNAL(returnPressed(const QString &)), 0, 0);
	connect(this, SIGNAL(returnPressed(const QString &)), receiver, slot);
}

#include "m_kvi_topiceditor.moc"
