// =============================================================================
//
//      --- kvi_asyncinputbox.cpp ---
//
//   This file is part of the KVIrc IRC client distribution
//   Copyright (C) 1999-2000 Szymon Stefanek (stefanek@tin.it)
//
//   This program is FREE software. You can redistribute it and/or
//   modify it under the terms of the GNU General Public License
//   as published by the Free Software Foundation; either version 2
//   of the License, or (at your opinion) any later version.
//
//   This program is distributed in the HOPE that it will be USEFUL,
//   but WITHOUT ANY WARRANTY; without even the implied warranty of
//   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
//   See the GNU General Public License for more details.
//
//   You should have received a copy of the GNU General Public License
//   along with this program. If not, write to the Free Software Foundation,
//   Inc, 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
//
// =============================================================================

#define _KVI_DEBUG_CHECK_RANGE_
#define _KVI_DEBUG_CLASS_NAME_ "KviAsyncInputBox"

#include <qlayout.h>

#include "kvi_app.h"
#include "kvi_asyncinputbox.h"
#include "kvi_label.h"
#include "kvi_lineedit.h"
#include "kvi_locale.h"
#include "kvi_pushbutton.h"

KviAsyncInputBox::KviAsyncInputBox(
	KviUserParser *parser, KviWindow *pWnd,
	const char *caption, const char *text, const char *initialtext, bool passwd)
	: KviDialog()
	, KviAsyncDialog(parser, pWnd)
{
	setCaption(caption);
	QGridLayout *g = new QGridLayout(this, 3, 2, 4, 4);
	KviLabel    *l = new KviLabel(text, this);
	l->adjustSize();
	l->setMinimumSize(l->sizeHint());
	g->addMultiCellWidget(l, 0, 0, 0, 1);

	m_pLined = new KviLineEdit(this);
	m_pLined->setText(initialtext);
	m_pLined->adjustSize();
	m_pLined->setMinimumSize(m_pLined->sizeHint());
	if( passwd )
		m_pLined->setEchoMode(KviLineEdit::Password);
	g->addMultiCellWidget(m_pLined, 1, 1, 0, 1);

	KviPushButton *b;
	b = new KviPushButton(_i18n_("OK"), this);
	b->adjustSize();
	b->setMinimumSize(b->sizeHint());
	b->setDefault(true);
	g->addWidget(b, 2, 0);
	connect(b, SIGNAL(clicked()), this, SLOT(accept()));

	b = new KviPushButton(_i18n_("Cancel"), this);
	b->adjustSize();
	b->setMinimumSize(b->sizeHint());
	g->addWidget(b, 2, 1);
	connect(b, SIGNAL(clicked()), this, SLOT(reject()));

	g->setRowStretch(0, 1);

	g->activate();
	QSize s(l->sizeHint());
	s.setWidth(s.width() + 15);
	resize(s); // Do minimum resizing
}

KviAsyncInputBox::~KviAsyncInputBox()
{
	// Nothing here
}

void KviAsyncInputBox::done(int r)
{
	KviDialog::done(r);
	KviStr data = m_pLined->text();
	runJob((result() == Accepted) ? data.ptr() : "");
	g_pApp->destroyLater(this);
}

#include "m_kvi_asyncinputbox.moc"
