#ifndef _KVI_DCC_VOICE_THREAD_H_INCLUDED_
#define _KVI_DCC_VOICE_THREAD_H_INCLUDED_

// =============================================================================
//
//      --- kvi_dcc_voice_thread.h ---
//
//   This file is part of the KVIrc IRC client distribution
//   Copyright (C) 2003 Robin Verduijn <robin@debian.org>
//
//   This program is FREE software. You can redistribute it and/or
//   modify it under the terms of the GNU General Public License
//   as published by the Free Software Foundation; either version 2
//   of the License, or (at your opinion) any later version.
//
//   This program is distributed in the HOPE that it will be USEFUL,
//   but WITHOUT ANY WARRANTY; without even the implied warranty of
//   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
//   See the GNU General Public License for more details.
//
//   You should have received a copy of the GNU General Public License
//   along with this program. If not, write to the Free Software Foundation,
//   Inc, 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
//
// =============================================================================

#include <qptrqueue.h>

#include "kvi_adpcm.h"
#include "kvi_dcc_thread.h"
#include "kvi_string.h"

class KviDccVoice;
class KviMutex;

// Use 4:1 compression
#define KVI_COMPRESSED_SAMPLE_SIZE_IN_CHARS  512

// Each buffer is ~0.128 sec of audio,
// read from sound card buffer in bytes!
#define KVI_READ_BUF_SIZE_IN_CHARS          2048
#define KVI_READ_BUF_SIZE_IN_SHORTS         1024
#define KVI_WRITE_BUF_SIZE_IN_CHARS         2048
#define KVI_WRITE_BUF_SIZE_IN_SHORTS        1024

#define KVI_DCC_VOICE_STATE_IDLE      0
#define KVI_DCC_VOICE_STATE_TALK      1
#define KVI_DCC_VOICE_STATE_PLAYBACK  2

/**
 * A compressed sample read or ready to send
 */
typedef struct _SampleStruct
{
	char           buffer[KVI_COMPRESSED_SAMPLE_SIZE_IN_CHARS];
	_SampleStruct *next;
} SampleStruct;

typedef struct KviDccVoiceData
{
	KviStr             nick;
	KviStr             username;
	KviStr             host;
	KviStr             szAddress;

	unsigned short     uPort;          // A port in host byte order
	unsigned long      uAddress;       // An internet address in network byte order
	KviDccVoice       *parent;

	KviStr             soundDevice;
	int                soundFd;        // Sound file descriptor
	bool               fullDuplex;
	char               soundReadBuffer[KVI_READ_BUF_SIZE_IN_CHARS];
	char               soundWriteBuffer[KVI_WRITE_BUF_SIZE_IN_CHARS];
	ADPCM_state        writeAdpcm;
	ADPCM_state        readAdpcm;
	SampleStruct      *sendHead;       // Send queue
	SampleStruct      *sendTail;       //
	int                lastSentSize;
	int                completeBuffers;
	int                lastReadSize;
	SampleStruct      *recvHead;       // Receive queue
	SampleStruct      *recvTail;       //
	SampleStruct      *tempSample;     //
	int                recvQueueCount;
	bool               bPlaying;       // Play state
	KviMutex          *playMutex;      // Relative mutex

	volatile int       state;
	int                prevState;
	KviStr             tmpBuffer;

	bool               use090CompatibleCompression;
	unsigned short int uPortToListenOn;
};

////////////////////////////////////////////////////////////////////////////////

class KviDccVoiceThread : public KviDccThread
{
public:
	KviDccVoiceThread(KviDccVoiceData *);
	~KviDccVoiceThread();

	void eventLoop();

	void appendEOF();
	bool sendSample();
	bool receiveData();
	void playbackLoop();
	void readSampleFromSoundcard();
	int  openSoundCard(bool read);

	static int openSoundCard(KviDccVoiceData *, bool read);
protected:
	KviDccVoiceData *m_pData;
};

////////////////////////////////////////////////////////////////////////////////

class KviDccVoiceAcceptThread : public KviDccVoiceThread
{
public:
	KviDccVoiceAcceptThread(KviDccVoiceData *);
	~KviDccVoiceAcceptThread();

	virtual void run();
};

////////////////////////////////////////////////////////////////////////////////

class KviDccVoiceRequestThread : public KviDccVoiceThread
{
public:
	KviDccVoiceRequestThread(KviDccVoiceData *);
	~KviDccVoiceRequestThread();

	virtual void run();
};

#endif // _KVI_DCC_CHAT_THREAD_H_INCLUDED_
