// =============================================================================
//
//      --- kvi_xutils.cpp ---
//
//   This file is part of the KVIrc IRC client distribution
//   Copyright (C) 1999-2000 Szymon Stefanek (stefanek@tin.it)
//
//   This program is FREE software. You can redistribute it and/or
//   modify it under the terms of the GNU General Public License
//   as published by the Free Software Foundation; either version 2
//   of the License, or (at your opinion) any later version.
//
//   This program is distributed in the HOPE that it will be USEFUL,
//   but WITHOUT ANY WARRANTY; without even the implied warranty of
//   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
//   See the GNU General Public License for more details.
//
//   You should have received a copy of the GNU General Public License
//   along with this program. If not, write to the Free Software Foundation,
//   Inc, 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
//
// =============================================================================

#define _KVI_DEBUG_CHECK_RANGE_
#define _KVI_DEBUG_CLASS_NAME_ "KviXUtils"

#include <qpainter.h>

#include "kvi_xutils.h"

/**
 * Draw a rectangle with the invert function.
 * Style != 0 means: draw it 'fat'
 */
void kvi_drawDragRectangle(QPainter *pa, QRect &rectToDraw, int style)
{
	if( rectToDraw.isNull() )
		return;
	pa->setPen(Qt::black);
	pa->setRasterOp(Qt::NotROP);

	pa->drawRect(rectToDraw);
	if( style > 0 )
		pa->drawRect(rectToDraw.x()+2, rectToDraw.y()+2, rectToDraw.width()-4, rectToDraw.height()-4);
	pa->drawRect(rectToDraw.x()+1, rectToDraw.y()+1, rectToDraw.width()-2, rectToDraw.height()-2);
}
