//=============================================================================
//
//   File : kvi_up_oper.cpp
//   Creation date : Sun Jul 09 2000 03:58:12 by Szymon Stefanek
//
//   This file is part of the KVirc irc client distribution
//   Copyright (C) 1999-2000 Szymon Stefanek (pragma at kvirc dot net)
//
//   This program is FREE software. You can redistribute it and/or
//   modify it under the terms of the GNU General Public License
//   as published by the Free Software Foundation; either version 2
//   of the License, or (at your opinion) any later version.
//
//   This program is distributed in the HOPE that it will be USEFUL,
//   but WITHOUT ANY WARRANTY; without even the implied warranty of
//   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
//   See the GNU General Public License for more details.
//
//   You should have received a copy of the GNU General Public License
//   along with this program. If not, write to the Free Software Foundation,
//   Inc. ,59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
//
//=============================================================================

#define __KVIRC__
#define _KVI_DEBUG_CHECK_RANGE_

#include "kvi_debug.h"
#include "kvi_uparser.h"
#include "kvi_command.h"
#include "kvi_error.h"
#include "kvi_locale.h"
#include "kvi_datacontainer.h"

#include <qregexp.h>





bool KviUserParser::parseOperatorAssignment(KviCommand *c,KviDataType * d)
{
	return false;
	/*
	ENTER_STACK_FRAME(c,"parseOperatorAssignment");

	c->skipSpace();

	char * rightOperStart = c->m_ptr;

	if(d->iDataType == KVI_DATA_TYPE_DICTREFERENCE)
	{
		// The right operand might be a dictionary reference!
		KviDataType rdt;
		bool bLastWasAVariable = true;
		KviStr dummy;
		do {
			if(*(c->m_ptr) == '%')
			{
				if(!bLastWasAVariable)c->setParsingDictionaryAssignment(false);
				bLastWasAVariable = true;
				if(!parseVariable(c,dummy,&rdt,false))return false;
			} else if(*(c->m_ptr) == '$')
			{
				if(bLastWasAVariable)c->setParsingDictionaryAssignment(true);
				bLastWasAVariable = false;
				if(!parseIdentifier(c,dummy))return false;
			} else {
				// no way.. this is not a dict reference
				// skip back and reparse it as a rvalue
				if(!bLastWasAVariable)c->setParsingDictionaryAssignment(false);
				goto parse_simple_rvalue;
			}
		} while(c->scopeObject());

		if(KviDictionary * dict = c->dictionaryReturn())
		{
			if(dict->isEmpty())
			{
				// Assigned an empty dictionary
				delete dict;
				d->pDataContainer->removeDictionary(d->szName.ptr());
			} else {
				// Assigned a valid non-empty dictionary
				d->pDataContainer->insertDictionary(d->szName.ptr(),dict);
			}
			return c->leaveStackFrame();
		}

		if(bLastWasAVariable)
		{
			switch(rdt.iDataType)
			{
				case KVI_DATA_TYPE_DICTREFERENCE:
					if(rdt.pDictionary)
					{
						if(rdt.pDictionary != d->pDictionary)
						{
							d->pDictionary->clear();
							KviDictionaryIterator it(*(rdt.pDictionary));
							while(it.current())
							{
								d->pDictionary->replace(it.currentKey(),new KviStr(*(it.current())));
								++it;
							}
							if(d->pDictionary->isEmpty())d->pDataContainer->removeDictionary(d->szName.ptr());
						}
					} else {
						d->pDataContainer->removeDictionary(d->szName.ptr());
					}
				break;
				case KVI_DATA_TYPE_DICTKEYSREFERENCE:
					if(rdt.pDictionary)
					{
						if(rdt.pDictionary != d->pDictionary)
						{
							d->pDictionary->clear();
							KviDictionaryIterator it(*(rdt.pDictionary));
							KviStr tmp;
							int idx=0;
							while(it.current())
							{
								tmp.setNum(idx);
								d->pDictionary->replace(tmp.ptr(),new KviStr(it.currentKey()));
								++it;
								idx++;
							}
							if(d->pDictionary->isEmpty())d->pDataContainer->removeDictionary(d->szName.ptr());
						}
					} else {
						d->pDataContainer->removeDictionary(d->szName.ptr());
					}
				break;
				case KVI_DATA_TYPE_ARRAYREFERENCE:
					if(rdt.pArray)
					{
						d->pDictionary->clear();
						unsigned int cnt = rdt.pArray->size();
						KviStr tmp;
						for(unsigned int u=0;u<cnt;u++)
						{
							KviStr * t = rdt.pArray->uncheckedAt(u);
							tmp.setNum(u);
							if(t)d->pDictionary->replace(tmp.ptr(),new KviStr(*t));
						}
					} else {
						d->pDataContainer->removeDictionary(d->szName.ptr());
					}
				break;
				default:
					goto parse_simple_rvalue;
				break;
			}
			return c->leaveStackFrame();
		}
		// No way.. need to reparse it...
		goto parse_simple_rvalue;
	}


	if(d->iDataType == KVI_DATA_TYPE_ARRAYREFERENCE)
	{
		// The right operand might be a dictionary reference!
		KviDataType rdt;
		bool bLastWasAVariable = true;
		KviStr dummy;
		do {
			if(*(c->m_ptr) == '%')
			{
				if(!bLastWasAVariable)c->setParsingArrayAssignment(false);
				bLastWasAVariable = true;
				if(!parseVariable(c,dummy,&rdt,false))return false;
			} else if(*(c->m_ptr) == '$')
			{
				if(bLastWasAVariable)c->setParsingArrayAssignment(true);
				bLastWasAVariable = false;
				if(!parseIdentifier(c,dummy))return false;
			} else {
				// no way.. this is not a dict reference
				// skip back and reparse it as a rvalue
				if(!bLastWasAVariable)c->setParsingArrayAssignment(false);
				goto parse_simple_rvalue;
			}
		} while(c->scopeObject());

		if(KviStringArray * array = c->arrayReturn())
		{
			if(array->isEmpty())
			{
				// Assigned an empty dictionary
				delete array;
				d->pDataContainer->removeArray(d->szName.ptr());
			} else {
				// Assigned a valid non-empty dictionary
				d->pDataContainer->insertArray(d->szName.ptr(),array);
			}
			return c->leaveStackFrame();
		}

		if(bLastWasAVariable)
		{
			switch(rdt.iDataType)
			{
				case KVI_DATA_TYPE_ARRAYREFERENCE:
					if(rdt.pArray)
					{
						if(rdt.pArray != d->pArray)
						{
							if(rdt.pArray->size() > 0)
							{
								d->pArray->copyFrom(rdt.pArray);
							} else {
								d->pDataContainer->removeArray(d->szName.ptr());
							}
						}
					} else {
						d->pDataContainer->removeArray(d->szName.ptr());
					}
				break;
				case KVI_DATA_TYPE_DICTREFERENCE:
					if(rdt.pDictionary)
					{
						d->pArray->clear();
						KviDictionaryIterator it(*(rdt.pDictionary));
						unsigned int u=0;
						while(it.current())
						{
							d->pArray->insert(u,new KviStr(*(it.current())));
							++it;
							++u;
						}
						if(d->pArray->isEmpty())d->pDataContainer->removeArray(d->szName.ptr());
					} else {
						d->pDataContainer->removeArray(d->szName.ptr());
					}
				break;
				case KVI_DATA_TYPE_DICTKEYSREFERENCE:
					if(rdt.pDictionary)
					{
						d->pArray->clear();
						KviDictionaryIterator it(*(rdt.pDictionary));
						unsigned int u=0;
						while(it.current())
						{
							d->pArray->insert(u,new KviStr(*(it.currentKey())));
							++it;
							++u;
						}
						if(d->pArray->isEmpty())d->pDataContainer->removeArray(d->szName.ptr());
					} else {
						d->pDataContainer->removeArray(d->szName.ptr());
					}
				break;
				default:
					goto parse_simple_rvalue;
				break;
			}
			return c->leaveStackFrame();
		}
		// No way.. need to reparse it...
		goto parse_simple_rvalue;
	}


parse_simple_rvalue:
	c->m_ptr = rightOperStart;

	KviStr szBuffer;

	switch(d->iDataType)
	{
		case KVI_DATA_TYPE_VARIABLE:
			if(!parseCmdFinalPart(c,szBuffer))return false;
			*(d->pVariable) = szBuffer;
			if(d->pVariable->isEmpty())d->pDataContainer->removeVariable(d->szName.ptr());
		break;
		case KVI_DATA_TYPE_DICTVARIABLE:
			if(!parseCmdFinalPart(c,szBuffer))return false;
			*(d->pVariable) = szBuffer;
			if(d->pVariable->isEmpty())d->pDataContainer->removeDictionaryVariable(d->szName.ptr(),d->szKey.ptr());
		break;
		case KVI_DATA_TYPE_ARRAYVARIABLE:
			if(!parseCmdFinalPart(c,szBuffer))return false;
			*(d->pVariable) = szBuffer;
			if(d->pVariable->isEmpty())d->pDataContainer->removeArrayVariable(d->szName.ptr(),d->uIndex);
		break;
		case KVI_DATA_TYPE_DICTREFERENCE:
		{
			KviStr szBuffer;
			if(!parseCmdFinalPart(c,szBuffer))return false;
			if(szBuffer.hasData())
			{
				KviDictionaryIterator it(*(d->pDictionary));
				while(it.current())
				{
					*(it.current()) = szBuffer;
					++it;
				}
			} else {
				d->pDataContainer->removeDictionary(d->szName.ptr());
			}
		}
		break;
		case KVI_DATA_TYPE_ARRAYREFERENCE:
		{
			KviStr szBuffer;
			if(!parseCmdFinalPart(c,szBuffer))return false;
			if(szBuffer.hasData())
			{
				unsigned int cnt = d->pArray->size();
				for(unsigned int u = 0;u < cnt;u++)
				{
					KviStr * t = d->pArray->uncheckedAt(u);
					if(t)*t = szBuffer;
					else {
						t = new KviStr(szBuffer);
						d->pArray->insert(u,t);
					}
				}
			} else {
				d->pDataContainer->removeArray(d->szName.ptr());
			}
		}
		break;
		default:
			return c->error(KviError_invalidLeftOperand);
		break;
	}

	return c->leaveStackFrame();
	*/
}

bool KviUserParser::executeOperatorSelfStringManipulate(KviCommand *c,KviStr * pVariable,char operation,const KviStr &szPar1,const KviStr &szPar2,const KviStr &szFlags)
{
	return false;
	/*
	ENTER_STACK_FRAME(c,"executeOperatorSelfStringManipulate (=~)");

	if(pVariable == 0)goto end_of_this_stuff;

	switch(operation)
	{
		case 't':
		case 'y': // transliteration
			pVariable->transliterate(szPar1.ptr(),szPar2.ptr());
		break;
		case 's': // substitution
		{
			bool bGlobal = szFlags.contains('g');

			QRegExp re(szPar1.ptr(),!szFlags.contains('i'),szFlags.contains('w'));
			re.setMinimal(false); // we want greedy matching!
			int idx = 0;
			QString str(pVariable->ptr());
			while((!str.isEmpty()) && (idx != -1))
			{
				int len;
				idx = re.search(str,idx);
				if(idx != -1)
				{
					len = re.matchedLength();
					if(len == 0)
					{
						c->warning(__tr2qs("The regular expression matched a zero-length substring: this is not valid in the s/// operator"));
						c->warning(__tr2qs("Skipping the substitution"));
						goto end_of_this_stuff;
					}
					str.remove(idx,len);

					KviStr szReplaced;
					char * p2 = szPar2.ptr();
					char * begin = p2;
					while(*p2)
					{
						if(*p2 == '\\')
						{
							p2++;
							if(*p2 >= '0' && *p2 <= '9')
							{
								szReplaced.append(begin,(p2 - begin) - 1);
								szReplaced.append(re.cap(*p2 - '0'));
								p2++;
								begin = p2;
							} else if(*p2)p2++;
						} else p2++;
					}
					if(begin != p2)szReplaced.append(begin);
					str.insert(idx,szReplaced.ptr());
					idx += szReplaced.len();

					if(!bGlobal)
					{
						*pVariable = str;
						goto end_of_this_stuff;
					}
				}
			}
			*pVariable = str;
		}
		break;
	}
end_of_this_stuff:

	return c->leaveStackFrame();
	*/
}

bool KviUserParser::parseOperatorSelfStringManipulate(KviCommand *c,KviDataType * d)
{
	return false;
	/*
	ENTER_STACK_FRAME(c,"parseOperatorSelfStringManipulate (=~)");

	c->skipSpace();

	KviStr szP1,szP2,szFlags;

	char op = *(c->m_ptr);

	switch(op)
	{
		case 'y':  // transliteration
		case 't':  // transliteration
		case 's':  // substitution
		{
			++(c->m_ptr);
			if(op == 't')
			{
				if(*(c->m_ptr)=='r')++(c->m_ptr); // allow tr/// usage
			}
			c->skipSpace();
			if(*(c->m_ptr)!='/')return c->error(KviError_slashCharacterExpected);
			++(c->m_ptr);
			if(!parseCmdUpTo(c,szP1,'/'))return false;
			if(!parseCmdUpTo(c,szP2,'/'))return false;
			if(!parseCmdFinalPart(c,szFlags))return false;
		}
		break;
		default:
			return c->error(KviError_unknownStringManipulationOperator);
		break;
	}

	switch(d->iDataType)
	{
		case KVI_DATA_TYPE_VARIABLE:
		case KVI_DATA_TYPE_DICTVARIABLE:
		case KVI_DATA_TYPE_ARRAYVARIABLE:
			if(!executeOperatorSelfStringManipulate(c,d->pVariable,op,szP1,szP2,szFlags))return false;
		break;
		case KVI_DATA_TYPE_DICTREFERENCE:
		{
			KviDictionaryIterator it(*(d->pDictionary));
			while(it.current())
			{
				if(!executeOperatorSelfStringManipulate(c,it.current(),op,szP1,szP2,szFlags))return false;
				++it;
			}
		}
		break;
		case KVI_DATA_TYPE_ARRAYREFERENCE:
		{
			unsigned int cnt = d->pArray->size();
			for(unsigned int u=0;u < cnt;u++)
			{
				if(!executeOperatorSelfStringManipulate(c,d->pArray->uncheckedAt(u),op,szP1,szP2,szFlags))return false;
			}
		}
		break;
		default:
			return c->error(KviError_invalidLeftOperand);
		break;
	}

	return c->leaveStackFrame();
	*/
}

bool KviUserParser::parseOperatorAppendString(KviCommand *c,KviOperatorParseStruct *s)
{
	return false;
	/*
	// strings
	ENTER_STACK_FRAME(c,"parseOperatorAppendString (.=)");

	switch(s->pDataType->iDataType)
	{
		case KVI_DATA_TYPE_VARIABLE:
		case KVI_DATA_TYPE_DICTVARIABLE:
		case KVI_DATA_TYPE_ARRAYVARIABLE:
			s->pDataType->pVariable->append(s->buffer);
		break;
		case KVI_DATA_TYPE_DICTREFERENCE:
			if(s->buffer.hasData())
			{
				KviDictionaryIterator it(*(s->pDataType->pDictionary));
				while(it.current())
				{
					it.current()->append(s->buffer);
					++it;
				}
			}
		break;
		case KVI_DATA_TYPE_ARRAYREFERENCE:
			if(s->buffer.hasData())
			{
				unsigned int cnt = s->pDataType->pArray->size();
				for(unsigned int u=0;u < cnt;u++)
				{
					KviStr * t = s->pDataType->pArray->uncheckedAt(u);
					if(!t)
					{
						t = new KviStr();
						s->pDataType->pArray->insert(u,t);
					}
					t->append(s->buffer);
				}
			}
		break;
		default:
			return c->error(KviError_invalidLeftOperand);
		break;
	}

	return c->leaveStackFrame();
	*/
}

bool KviUserParser::parseOperatorAppendToken(KviCommand *c,KviOperatorParseStruct *s)
{
	return false;
	/*
	// strings
	ENTER_STACK_FRAME(c,"parseOperatorAppendToken (<<)");

	switch(s->pDataType->iDataType)
	{
		case KVI_DATA_TYPE_VARIABLE:
		case KVI_DATA_TYPE_DICTVARIABLE:
			if(s->pDataType->pVariable->hasData())s->pDataType->pVariable->append(' ');
			s->pDataType->pVariable->append(s->buffer);
		break;
		case KVI_DATA_TYPE_DICTREFERENCE:
			if(s->buffer.hasData())
			{
				KviDictionaryIterator it(*(s->pDataType->pDictionary));
				while(it.current())
				{
					if(it.current()->hasData())it.current()->append(' ');
					it.current()->append(s->buffer);
					++it;
				}
			}
		break;
		case KVI_DATA_TYPE_ARRAYREFERENCE:
			if(s->buffer.hasData())
			{
				unsigned int cnt = s->pDataType->pArray->size();
				for(unsigned int u=0;u < cnt;u++)
				{
					KviStr * t = s->pDataType->pArray->uncheckedAt(u);
					if(!t)
					{
						t = new KviStr();
						s->pDataType->pArray->insert(u,t);
					} else {
						if(t->hasData())t->append(' ');
					}
					t->append(s->buffer);
				}
			}
		break;
		default:
			return c->error(KviError_invalidLeftOperand);
		break;
	}

	return c->leaveStackFrame();
	*/
}


bool KviUserParser::parseOperatorAppendList(KviCommand *c,KviOperatorParseStruct *s)
{
	return false;
	/*
	// strings
	ENTER_STACK_FRAME(c,"parseOperatorAppendList (<,)");

	switch(s->pDataType->iDataType)
	{
		case KVI_DATA_TYPE_VARIABLE:
		case KVI_DATA_TYPE_DICTVARIABLE:
			if(s->pDataType->pVariable->hasData())s->pDataType->pVariable->append(',');
			s->pDataType->pVariable->append(s->buffer);
		break;
		case KVI_DATA_TYPE_DICTREFERENCE:
			if(s->buffer.hasData())
			{
				KviDictionaryIterator it(*(s->pDataType->pDictionary));
				while(it.current())
				{
					if(it.current()->hasData())it.current()->append(',');
					it.current()->append(s->buffer);
					++it;
				}
			}
		break;
		case KVI_DATA_TYPE_ARRAYREFERENCE:
			if(s->buffer.hasData())
			{
				unsigned int cnt = s->pDataType->pArray->size();
				for(unsigned int u=0;u < cnt;u++)
				{
					KviStr * t = s->pDataType->pArray->uncheckedAt(u);
					if(!t)
					{
						t = new KviStr();
						s->pDataType->pArray->insert(u,t);
					} else {
						if(t->hasData())t->append(',');
					}
					t->append(s->buffer);
				}
			}
		break;
		default:
			return c->error(KviError_invalidLeftOperand);
		break;
	}

	return c->leaveStackFrame();
	*/
}

bool KviUserParser::evaluateNumericLeftOperand(KviCommand *c,KviOperatorParseStruct *s,const char * oper)
{
	return false;
	/*
	ENTER_STACK_FRAME(c,"evaluateNumericLeftOperand");

	switch(s->pDataType->iDataType)
	{
		case KVI_DATA_TYPE_VARIABLE:
		case KVI_DATA_TYPE_DICTVARIABLE:
		case KVI_DATA_TYPE_ARRAYVARIABLE:
			if(s->pDataType->pVariable->isEmpty())
			{
				if(s->pDataType->iDataType == KVI_DATA_TYPE_DICTVARIABLE)
				{
					c->warning(__tr("Left operand of operator %s (%s{%s}) is undefined : assuming 0"),
						oper,s->pDataType->szName.ptr(),s->pDataType->szKey.ptr());
				} else if(s->pDataType->iDataType == KVI_DATA_TYPE_ARRAYVARIABLE)
				{
					c->warning(__tr("Left operand of operator %s (%s[%s]) is undefined : assuming 0"),
						oper,s->pDataType->szName.ptr(),s->pDataType->szKey.ptr());
				} else {
					c->warning(__tr("Left operand of operator %s (%s) is undefined : assuming 0"),
						oper,s->pDataType->szName.ptr());
				}
				*(s->pDataType->pVariable) = "0";
			}
		break;
		default:
			return c->error(KviError_multipleOpsNotSupportedForOperator);
		break;
	}

	bool bOk;
	s->iLeftOp = s->pDataType->pVariable->toInt(&bOk);
	if(!bOk){
		// Do NOT recover this...
		// Changing the variable to a number is not a good solution
		// and not incrementing it may be dangerous in loops (infinite loop)
		if(s->pDataType->iDataType == KVI_DATA_TYPE_DICTVARIABLE)
		{
			return c->error(KviError_leftOperandIsNotANumber,__tr("Variable %s{%s} evaluated to '%s' in operator %s (not a number)"),
				s->pDataType->szName.ptr(),s->pDataType->szKey.ptr(),s->pDataType->pVariable->ptr(),oper);
		} else if(s->pDataType->iDataType == KVI_DATA_TYPE_ARRAYVARIABLE)
		{
			return c->error(KviError_leftOperandIsNotANumber,__tr("Variable %s[%s] evaluated to '%s' in operator %s (not a number)"),
				s->pDataType->szName.ptr(),s->pDataType->szKey.ptr(),s->pDataType->pVariable->ptr(),oper);
		} else {
			return c->error(KviError_leftOperandIsNotANumber,__tr("Variable %s evaluated to '%s' in operator %s (not a number)"),
				s->pDataType->szName.ptr(),s->pDataType->pVariable->ptr(),oper);
		}
	}
	return c->leaveStackFrame();
	*/
}

bool KviUserParser::evaluateNumericRightOperand(KviCommand *c,KviOperatorParseStruct *s,const char * oper)
{
	return false;
	/*
	ENTER_STACK_FRAME(c,"evaluateNumericRightOperand");
	bool bOk;
	s->iRightOp = s->buffer.toInt(&bOk);
	if(!bOk)
	{
		return c->error(KviError_rightOperandIsNotANumber,__tr("Right operand of operator %s evaluated to '%s' (not a number)"),
			oper,s->buffer.ptr());
	}
	return c->leaveStackFrame();
	*/
}

bool KviUserParser::parseOperatorIncrement(KviCommand *c,KviOperatorParseStruct *s)
{
	return false;
	/*
	ENTER_STACK_FRAME(c,"parseOperatorIncrement");
	if(!evaluateNumericLeftOperand(c,s,"++"))return false;
	s->iLeftOp++;
	s->pDataType->pVariable->setNum(s->iLeftOp);
	return c->leaveStackFrame();
	*/
}

bool KviUserParser::parseOperatorSelfAddition(KviCommand *c,KviOperatorParseStruct *s)
{
	return false;
	/*
	ENTER_STACK_FRAME(c,"parseOperatorSelfAddition");
	if(!evaluateNumericLeftOperand(c,s,"+="))return false;
	if(!evaluateNumericRightOperand(c,s,"+="))return false;
	s->pDataType->pVariable->setNum(s->iLeftOp + s->iRightOp);
	return c->leaveStackFrame();
	*/
}

bool KviUserParser::parseOperatorDecrement(KviCommand *c,KviOperatorParseStruct *s)
{
	return false;
	/*
	ENTER_STACK_FRAME(c,"parseOperatorDecrement");
	if(!evaluateNumericLeftOperand(c,s,"--"))return false;
	s->iLeftOp--;
	s->pDataType->pVariable->setNum(s->iLeftOp);
	return c->leaveStackFrame();
	*/
}

bool KviUserParser::parseOperatorSelfSubtraction(KviCommand *c,KviOperatorParseStruct *s)
{
	return false;
	/*
	ENTER_STACK_FRAME(c,"parseOperatorSelfSubtraction");
	if(!evaluateNumericLeftOperand(c,s,"-="))return false;
	if(!evaluateNumericRightOperand(c,s,"-="))return false;
	s->pDataType->pVariable->setNum(s->iLeftOp - s->iRightOp);
	return c->leaveStackFrame();
	*/
}

bool KviUserParser::parseOperatorSelfMultiply(KviCommand *c,KviOperatorParseStruct *s)
{
	return false;
	/*
	ENTER_STACK_FRAME(c,"parseOperatorSelfMultiply");
	if(!evaluateNumericLeftOperand(c,s,"*="))return false;
	if(!evaluateNumericRightOperand(c,s,"*="))return false;
	s->pDataType->pVariable->setNum(s->iLeftOp * s->iRightOp);
	return c->leaveStackFrame();
	*/
}

bool KviUserParser::parseOperatorSelfModulo(KviCommand *c,KviOperatorParseStruct *s)
{
	return false;
	/*
	ENTER_STACK_FRAME(c,"parseOperatorSelfModulo");
	if(!evaluateNumericLeftOperand(c,s,"%="))return false;
	if(!evaluateNumericRightOperand(c,s,"%="))return false;
	if(s->iRightOp == 0)return c->error(KviError_moduloByZero);
	else s->pDataType->pVariable->setNum(s->iLeftOp % s->iRightOp);
	return c->leaveStackFrame();
	*/
}

bool KviUserParser::parseOperatorSelfOr(KviCommand *c,KviOperatorParseStruct *s)
{
	return false;
	/*
	ENTER_STACK_FRAME(c,"parseOperatorSelfOr");
	if(!evaluateNumericLeftOperand(c,s,"|="))return false;
	if(!evaluateNumericRightOperand(c,s,"|="))return false;
	s->pDataType->pVariable->setNum(s->iLeftOp * s->iRightOp);
	return c->leaveStackFrame();
	*/
}

bool KviUserParser::parseOperatorSelfAnd(KviCommand *c,KviOperatorParseStruct *s)
{
	return false;
	/*
	ENTER_STACK_FRAME(c,"parseOperatorSelfAnd");
	if(!evaluateNumericLeftOperand(c,s,"&="))return false;
	if(!evaluateNumericRightOperand(c,s,"&="))return false;
	s->pDataType->pVariable->setNum(s->iLeftOp & s->iRightOp);
	return c->leaveStackFrame();
	*/
}

//bool KviUserParser::parseOperatorSelfNot(KviCommand *c,KviOperatorParseStruct *s)
//{
//	ENTER_STACK_FRAME(c,"parseOperatorSelfNot");
//	if(!evaluateNumericLeftOperand(c,s,"!="))return false;
//	if(!evaluateNumericRightOperand(c,s,"!="))return false;
//	s->pDataType->pVariable->setNum(!(s->iRightOp));
//	return c->leaveStackFrame();
//}

bool KviUserParser::parseOperatorSelfDivide(KviCommand *c,KviOperatorParseStruct *s)
{
	return false;
	/*
	ENTER_STACK_FRAME(c,"parseOperatorSelfDivide");
	if(!evaluateNumericLeftOperand(c,s,"/="))return false;
	if(!evaluateNumericRightOperand(c,s,"/="))return false;
	if(s->iRightOp == 0)return c->error(KviError_divisionByZero);
	else s->pDataType->pVariable->setNum(s->iLeftOp / s->iRightOp);
	return c->leaveStackFrame();
	*/
}
/*

bool KviUserParser::parseOperatorInsertDict(KviCommand *c,KviOperatorParseStruct *s)
{
	ENTER_STACK_FRAME(c,"parseOperatorInsertDict");
	KviDictionaryIterator it(*(s->pRightDataType->pDictionary));
	if(s->pRightDataType->pDictionary)
	{
		while(it.current())
		{
			s->pDataType->pDictionary->replace(it.currentKey(),new KviStr(*(it.current())));
			++it;
		}
	}
	if(s->pDataType->pDictionary->isEmpty())
	{
		s->pDataType->pDataContainer->removeDictionary(s->pDataType->szName.ptr());
	}	
	return c->leaveStackFrame();
}
*/

typedef bool (KviUserParser::*parse_operator_func)(KviCommand *,KviOperatorParseStruct *);



bool KviUserParser::parseOperator(KviCommand *c,KviDataType * d)
{
	return false;
	/*
	ENTER_STACK_FRAME(c,"parseOperator");

	parse_operator_func func = ((parse_operator_func)0);
	char operBegin = 0;

	switch(*(c->m_ptr))
	{
		case '=':
			++(c->m_ptr);
			switch(*(c->m_ptr))
			{
				case '~':
					++(c->m_ptr);
					return parseOperatorSelfStringManipulate(c,d);
				break;
				default:
					return parseOperatorAssignment(c,d);
				break;
			}
		break;
		case '+':
			++(c->m_ptr);
			switch(*(c->m_ptr))
			{
				case '+': func = KVI_PTR2MEMBER(KviUserParser::parseOperatorIncrement);         break;
				case '=': func = KVI_PTR2MEMBER(KviUserParser::parseOperatorSelfAddition);      break;
				default: operBegin = '+'; break;
			}
		break;
		case '-':
			++(c->m_ptr);
			switch(*(c->m_ptr))
			{
				case '-': func = KVI_PTR2MEMBER(KviUserParser::parseOperatorDecrement);         break;
				case '=': func = KVI_PTR2MEMBER(KviUserParser::parseOperatorSelfSubtraction);   break;
				default: operBegin = '-'; break;
			}
		break;
		case '*':
		case '%':
		case '|':
		case '&':
		case '!':
		case '/':
			operBegin = *(c->m_ptr);
			++(c->m_ptr);
			if(*(c->m_ptr) == '=')
			{
				switch(operBegin)
				{
					case '*': func = KVI_PTR2MEMBER(KviUserParser::parseOperatorSelfMultiply);  break;
					case '%': func = KVI_PTR2MEMBER(KviUserParser::parseOperatorSelfModulo);    break;
					case '|': func = KVI_PTR2MEMBER(KviUserParser::parseOperatorSelfOr);        break;
					case '&': func = KVI_PTR2MEMBER(KviUserParser::parseOperatorSelfAnd);       break;
//					case '!': func = KVI_PTR2MEMBER(KviUserParser::parseOperatorSelfNot);       break;
					case '/': func = KVI_PTR2MEMBER(KviUserParser::parseOperatorSelfDivide);    break;
				}
			}
		break;
		case '.':
			++(c->m_ptr);
			switch(*(c->m_ptr))
			{
				case '=': func = KVI_PTR2MEMBER(KviUserParser::parseOperatorAppendString);      break;
				default: operBegin = '.';                                                       break;
			}
		break;
		case '<':
			++(c->m_ptr);
			switch(*(c->m_ptr))
			{
				case '+': func = KVI_PTR2MEMBER(KviUserParser::parseOperatorAppendString);      break;
				case '<': func = KVI_PTR2MEMBER(KviUserParser::parseOperatorAppendToken);       break;
				case ',': func = KVI_PTR2MEMBER(KviUserParser::parseOperatorAppendList);        break;
//				case '-':
//					func = KVI_PTR2MEMBER(KviUserParser::parseOperatorInsertDict);
//					bDictOperator = true;
//				break;
				default: operBegin = '<';                                                       break;
			}
		break;
	}

	++(c->m_ptr);
	KviOperatorParseStruct ops;
	ops.pDataType = d;

	if(func == ((parse_operator_func)0))
	{
		return c->error(KviError_unknownOperator,__tr("operator %c%c"),operBegin ? operBegin : ' ',*(c->m_ptr));
	} else {
		if(!parseCmdFinalPart(c,ops.buffer))return false;
		return (this->*func)(c,&ops) ? c->leaveStackFrame() : false;
	}
	*/
	// newer here!
}
