/***************************************************************************
 *   Copyright (C) 2004-2008 by Giovanni Venturi                           *
 *   giovanni@ksniffer.org                                                 *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   51 Franklin Steet, Fifth Floor, Boston, MA  02110-1301, USA.          *
 ***************************************************************************/

#include <qlistview.h>

#include "packetmanager.h"
#include "protocols/portnumbernamelist.h"
#include "ksnifferviewitem.h"

KSnifferViewItem::KSnifferViewItem( QListView *parent, PacketManager *pm, PortNumberNameList *pnnl, bool showProtocolName )
  : QListViewItem( parent ), m_packetData( pm ), m_portNumberNameList( pnnl ), m_showProtocolName(showProtocolName)
{
  init();
}


KSnifferViewItem::KSnifferViewItem( QListView *parent, QListViewItem *after, PacketManager *pm, PortNumberNameList *pnnl,
  bool showProtocolName) : QListViewItem( parent, after ), m_packetData( pm ), m_portNumberNameList( pnnl ),
    m_showProtocolName(showProtocolName)
{
  init();
}


void KSnifferViewItem::init()
{
  setText( 0, QString::number( m_packetData->getFrameNumber() ) );
  setText( 1, m_packetData->strTimeStamp() );
  setText( 2, m_packetData->strSourceAddress() );
  setText( 3, m_packetData->strDestinationAddress() );
  if (m_showProtocolName)
    setText( 4, m_packetData->strProtocolServiceName() );
  else
    setText( 4, m_packetData->strProtocol() );
  setText( 5, m_packetData->strInfo() );
}


int KSnifferViewItem::compare( QListViewItem *i, int col, bool ascending ) const
{
  if (col == 0) // frame number
    return text(col).toLong() - i->text(col).toLong();
  else
    return QListViewItem::compare( i, col, ascending );
}
