/***************************************************************************
                          kshowmaildock.cpp  -  description
                             -------------------
    begin                : Wed Jan 3 2001
    copyright            : (C) 2001 by Eggert Ehmke
    email                : eggert.ehmke@berlin.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include <qpixmap.h>
#include <qpainter.h>
#include <qtooltip.h>

#include <kpopupmenu.h>
#include <kstandarddirs.h>
#include <kglobalsettings.h>
#include <klocale.h>
#include <kdebug.h>

#include "kshowmail.h"
#include "kshowmaildock.h"

KShowMailDock::KShowMailDock(QWidget* parent, KAction *actionRefresh )
: KSystemTray (parent, 0),
      m_background (QPixmap(::locate ("data", "kshowmail/pics/kshowmail24.png")))
{
//  kdDebug () << "KShowMailDock::KShowMailDock" << endl;
  drawText ("?", Qt::red);
  QToolTip::add (this, i18n("KShowmail: a powerful pop3 email checker"));

  show();

  actionRefresh->plug( contextMenu() );
  //((KShowMailApp*)parent)->m_actionRefresh->plug (contextMenu());
  connect (contextMenu(),SIGNAL(activated(int)),this, SIGNAL(sigActivated(int)));
  connect (contextMenu(),SIGNAL(highlighted(int)),this, SIGNAL(sigHighlighted(int)));
}

void KShowMailDock::drawText (const QString str, const QColor& color)
{
  setPixmap (m_background);
  QPixmap* pix = pixmap ();
   if (pix && !pix->isNull ())
  {
    QPainter p (pix);
//     p.setFont (KGlobalSettings::toolBarFont());
     p.setFont (KGlobalSettings::windowTitleFont());
    p.setPen (color);
     p.drawText  (0,0,24,24,QPainter::AlignCenter,str,str.length());
  }
  else
    kdError () << "No pixmap for traybar !" << endl;
}

void KShowMailDock::drawNumber (int n, const QColor& color)
{
  setPixmap (m_background);
  QPixmap* pix = pixmap ();
   if (pix && !pix->isNull ())
  {
    QString num (QString::number(n));
    QPainter p (pix);
     p.setFont (KGlobalSettings::toolBarFont());
    p.setPen (color);
     p.drawText  (0,0,24,24,QPainter::AlignCenter,num,num.length());
  }
  else
    kdError () << "No pixmap for traybar !" << endl;
}

void KShowMailDock::clear ()
{
  setPixmap (m_background);
}

