/***************************************************************************
 *   Copyright (C) 2005 by SUZUKI Tasuku                                   *
 *   tasuku@linux-life.net                                                 *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/
#include "kktitem.h"

#include <kglobal.h>
#include <klocale.h>
#include <kdebug.h>

using namespace KKTemplate;

KKTItem::KKTItem( QDomElement& elem, QString path )
	: m_strTitle( QString::null )
	, m_strFilename( QString::null )
	, m_strComment( QString::null )
	, m_strAuthor( QString::null )
	, m_strMail( QString::null )
{
	if( elem.hasAttribute( "path" ) )
	{
		path += elem.attribute( "path" ) + "/";
	}
	if( elem.hasAttribute( "src" ) )
	{
		m_strFilename = path + elem.attribute( "src" );
	}
	if( elem.hasAttribute( "preview" ) )
	{
		m_pixPreview = QPixmap( path + elem.attribute( "preview" ) );
	}
	if( elem.hasAttribute( "comment" ) )
	{
		m_strComment = elem.attribute( "comment" );
	}
	if( elem.hasAttribute( "author" ) )
	{
		m_strAuthor = elem.attribute( "author" );
	}
	if( elem.hasAttribute( "mail" ) )
	{
		m_strMail = elem.attribute( "mail" );
	}

	QString lang = KGlobal::locale()->language();
	for( QDomNode node = elem.firstChild(); !node.isNull(); node = node.nextSibling() )
	{
		QDomElement e = node.toElement();
		if( e.tagName() == "title" )
		{
			if( ( e.attribute( "lang" ) == "C" && m_strTitle.isNull() ) || e.attribute( "lang" ) == lang )
			{
				m_strTitle = e.text();
			}
		}
	}
}

KKTItem::~KKTItem()
{
}
