/***************************************************************************
 *   Copyright (C) 2005 by SUZUKI Tasuku                                   *
 *   tasuku@linux-life.net                                                 *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/
#include "kkdcategorybutton.h"
#include "kkdcategorymenu.h"
#include "kkdcategoryitem.h"

#include <qdom.h>
#include <qfile.h>
#include <kstandarddirs.h>
#include <klocale.h>
#include <kdebug.h>

using namespace KKDSubscribeTemplate;

KKDCategoryButton::KKDCategoryButton( QWidget* parent, const char* name )
	: KPushButton( parent, name ), m_category( QString::null )
{
	KKDCategoryMenu* menu = new KKDCategoryMenu( this );
	QString datafile = locateLocal( "data", KGlobal::instance()->instanceName() + "/template.xml" );
	QDomDocument doc( "kktemplate" );
	QFile file( datafile );
	if( file.open( IO_ReadOnly ) )
	{
		if( !doc.setContent( &file ) )
		{
			kdError() << i18n( "Can't analize %1" ).arg( datafile ) << endl;
			file.close();
			return;
		}
		file.close();
	}
	else
	{
		kdError() << i18n( "Can't open %1" ).arg( datafile ) << endl;
		return;
	}
	KKDCategoryItem* item = new KKDCategoryItem( doc.documentElement() );
	menu->setItem( item );
	delete item;
	connect( menu, SIGNAL( decided( int, const QString&, const QString& ) ), this, SLOT( categoryChanged( int, const QString&, const QString& ) ) );
	setPopup( menu );
}

KKDCategoryButton::~KKDCategoryButton()
{
}

void KKDCategoryButton::categoryChanged( int, const QString& str, const QString& path )
{
	m_category = "/" + path;
	setText( "/" + str );
}
