/***************************************************************************
 *   Copyright (C) 2005 by SUZUKI Tasuku                                   *
 *   tasuku@linux-life.net                                                 *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/
#include "kkapersonwidget.h"
#include "kkapersonaldata.h"

#include <kdebug.h>
#include <klocale.h>

using namespace KKAddressBook;

KKAPersonWidget::KKAPersonWidget( QWidget* parent, const char* name )
 : QHBox( parent, name )
 , m_data( NULL )
{
	m_prefix = new KComboBox( this );
	m_prefix->setEditable( true );
	m_name = new KLineEdit( this );
	m_suffix = new KComboBox( this );
	m_suffix->setEditable( true );

	QStringList list;
	list = QStringList::split( QString( " " ), i18n( "Dr. Mr. Miss. Mrs. Ms. Prof." ) );
	list.push_front( "" );
	m_prefix->insertStringList( list );
	list = QStringList::split( QString( " " ), i18n( "I II III Jr. Sr." ) );
	list.push_front( "" );
	m_suffix->insertStringList( list );

	setStretchFactor( m_prefix, 1 );
	setStretchFactor( m_name, 5 );
	setStretchFactor( m_suffix, 1 );

	connect( m_name, SIGNAL( textChanged( const QString& ) ), this, SIGNAL( nameChanged( const QString& ) ) );
}


KKAPersonWidget::~KKAPersonWidget()
{
}

void KKAPersonWidget::setData( KKAPersonalData* data )
{
	if( m_data == data ) return;
	if( m_data )
	{
		disconnect( m_prefix, SIGNAL( textChanged( const QString& ) ), m_data, SLOT( setPrefix( const QString& ) ) );
		disconnect( m_name, SIGNAL( textChanged( const QString& ) ), m_data, SLOT( setName( const QString& ) ) );
		disconnect( m_suffix, SIGNAL( textChanged( const QString& ) ), m_data, SLOT( setSuffix( const QString& ) ) );
	}
	m_data = data;
	if( m_data )
	{
		m_prefix->setCurrentText( m_data->prefix() );
		m_name->setText( m_data->name() );
		m_suffix->setCurrentText( m_data->suffix() );
		connect( m_prefix, SIGNAL( textChanged( const QString& ) ), m_data, SLOT( setPrefix( const QString& ) ) );
		connect( m_name, SIGNAL( textChanged( const QString& ) ), m_data, SLOT( setName( const QString& ) ) );
		connect( m_suffix, SIGNAL( textChanged( const QString& ) ), m_data, SLOT( setSuffix( const QString& ) ) );
	}
	else
	{
		m_prefix->setCurrentText( "" );
		m_name->setText( "" );
		m_suffix->setCurrentText( "" );
	}
}
