/***************************************************************************
 *   Copyright (C) 2005 by SUZUKI Tasuku                                   *
 *   tasuku@linux-life.net                                                 *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/
#ifndef _KKACONTACTDATA_H_
#define _KKACONTACTDATA_H_

#include "kkapersonaldata.h"
#include "kkaaddressdata.h"

#include <qobject.h>
#include <qptrlist.h>
#include <qdom.h>

namespace KKAddressBook
{
	class KKAHomeAddress;
	class KKAOfficeAddress;

	class KKAContactData : public KKAPersonalData
	{
		Q_OBJECT
	public:
		KKAContactData( QObject* parent );
		KKAContactData( QObject* parent
					  , const QString& prefix
					  , const QString& name
					  , const QString& suffix
					  );
		KKAContactData( QObject* parent, QDomElement e );
		QDomElement toElement( QDomDocument& doc );

		KKAHomeAddress* home(){ return m_home; }
		const KKAHomeAddress* const_home() const { return m_home; }
		KKAOfficeAddress* office(){ return m_office; }
		const KKAOfficeAddress* const_office() const { return m_office; }

		KKAAddressData* current();
		const KKAAddressData* const_current() const;
		void setCurrent( KKAAddressData::LocationType l );

	private:
		KKAHomeAddress* m_home;
		KKAOfficeAddress* m_office;
	};
}
#endif /* _KKACONTACTDATA_H_ */
