/*
    Copyright (C) 2008  Tim Fechtner < urwald at users dot sourceforge dot net >

    This program is free software; you can redistribute it and/or
    modify it under the terms of the GNU General Public License as
    published by the Free Software Foundation; either version 2 of
    the License or (at your option) version 3 or any later version
    accepted by the membership of KDE e.V. (or its successor approved
    by the membership of KDE e.V.), which shall act as a proxy
    defined in Section 14 of version 3 of the license.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program.  If not, see <http://www.gnu.org/licenses/>.
*/

#include "settings_stream_widget_splitting.h"

settings_stream_widget_splitting::settings_stream_widget_splitting(QWidget * parent)
  : QWidget(parent)
{
  setupUi(this);
  connect(kcfg_silenceWindow,
           SIGNAL(valueChanged(int)),
           this,
           SLOT(correct_search_window(int)));
  connect(kcfg_searchWindow,
           SIGNAL(valueChanged(int)),
           this,
           SLOT(correct_silence_window(int)));
}

settings_stream_widget_splitting::~settings_stream_widget_splitting()
{
}

void settings_stream_widget_splitting::correct_search_window(const int silence_window)
{
  if (kcfg_searchWindow->value() <= silence_window) {
    kcfg_searchWindow->setValue(silence_window + 1);
  };
}

void settings_stream_widget_splitting::correct_silence_window(const int search_window)
{
  if (kcfg_silenceWindow->value() >= search_window) {
    kcfg_silenceWindow->setValue(search_window - 1);
  };
}
