/*
    Copyright (C) 2008  Tim Fechtner < urwald at users dot sourceforge dot net >

    This program is free software; you can redistribute it and/or
    modify it under the terms of the GNU General Public License as
    published by the Free Software Foundation; either version 2 of
    the License or (at your option) version 3 or any later version
    accepted by the membership of KDE e.V. (or its successor approved
    by the membership of KDE e.V.), which shall act as a proxy
    defined in Section 14 of version 3 of the license.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program.  If not, see <http://www.gnu.org/licenses/>.
*/

#include "settings_stream_widget_saving.h"

settings_stream_widget_saving::settings_stream_widget_saving(QWidget * parent) : QWidget(parent)
{
  setupUi(this);

  // Setting the items of the combo boxes. We do it here because QDesigner doesn't support
  // semantic markup for items.
  kcfg_splittedFilesOverwrite->addItem(i18nc("@item:inlistbox overwrite splitted files",
                                             "Always"));
  kcfg_splittedFilesOverwrite->addItem(i18nc("@item:inlistbox overwrite splitted files",
                                             "Larger"));
  kcfg_splittedFilesOverwrite->addItem(i18nc("@item:inlistbox overwrite splitted files",
                                             "Never"));
  kcfg_singleFileOverwrite->addItem(i18nc("@item:inlistbox override single file", "Yes"));
  kcfg_singleFileOverwrite->addItem(i18nc("@item:inlistbox override single file", "No"));

  connect(kcfg_splittedFilesOverwrite,
           SIGNAL(currentIndexChanged(int)),
           this,
           SLOT(handleCheckboxTruncate(int)));
}

settings_stream_widget_saving::~settings_stream_widget_saving()
{
}

void settings_stream_widget_saving::handleCheckboxTruncate(const int entry_number)
{
  if (entry_number == 0) {
    kcfg_truncateDuplicatesInIncomplete->setEnabled(false);
  } else {
    kcfg_truncateDuplicatesInIncomplete->setEnabled(true);
  };
}
