/*
    Copyright (C) 2009  Tim Fechtner < urwald at users dot sourceforge dot net >

    This program is free software; you can redistribute it and/or
    modify it under the terms of the GNU General Public License as
    published by the Free Software Foundation; either version 2 of
    the License or (at your option) version 3 or any later version
    accepted by the membership of KDE e.V. (or its successor approved
    by the membership of KDE e.V.), which shall act as a proxy
    defined in Section 14 of version 3 of the license.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program.  If not, see <http://www.gnu.org/licenses/>.
*/

#ifndef PROXYINFO_H
#define PROXYINFO_H

#include "version.h"
#ifdef LIBPROXY_FOUND
#include "proxy.h"
#endif

#include <QStringList>

/** \brief Provides information about the proxy server
  *
  * This class provides information about the proxy server that have to be used. You can not
  * create in instance of this class. Just use the static function #proxyserver().
  */
class proxyinfo
{

  public:
    /** If proxy configuration is "automatic" (this is the default), than libproxy is used to get
    * the proxy servers that have to be used to connect to the specified URL. If the proxy
    * configuration is manually, it uses <tt>settings_general::proxyServer()</tt> to determinate
    * the proxy server.
    * \note If proxy configuration is "automatic" but compiling against libproxy is disabled,
    *       than we fall back to "manual" silently->
    * @param url The URL for which the proxy server will be obtained
    * @returns A list of proxy servers to be used. If the first proxy fails, the second should be
    *          tried, etc... The format of the returned proxy strings are as follows: <ul>
    *          <li>%http://[username:password@]proxy:port <i>(from libproxy)</i></li>
    *          <li>%socks://[username:password@]proxy:port <i>(from libproxy)</i></li>
    *          <li>%direct:// <i>(= don't use any proxy server - from libproxy or if the proxy
    *                             field in the global config file is empty)</i></li>
    *          <li><i>(the entry from the global config file - if it is not empty)</i></li>
    *          </ul> It is guaranteed that the list has at least 1 entry.*/
    static QStringList proxyserver(const QString & url);

  private:
    /** The constructor. As the class will not be instanciated, he is declared private. */
    proxyinfo();
    /** The desctructor. As the class will not be instanciated, he is declared private. */
    virtual ~proxyinfo();
    /** The only instance of this class. */
    static proxyinfo internal_instance;
    /** The internal, non-static implementation of #proxyserver(). */
    QStringList internal_proxyserver(const QString & url) const;
#ifdef LIBPROXY_FOUND
    /** A pointer to the factory instance of libproxy.
    *
    * This member is only available when compiled against libproxy. */
    pxProxyFactory *libproxy_factory;
#endif
    /** @returns The proxy server from <tt>settings_general::proxyServer()</tt> if this
    *            string is not empty; else it returns "direct://". */
    QStringList manual_proxyserver() const;

};

#endif
