/*
    Copyright (C) 2008-2009  Tim Fechtner < urwald at users dot sourceforge dot net >

    This program is free software; you can redistribute it and/or
    modify it under the terms of the GNU General Public License as
    published by the Free Software Foundation; either version 2 of
    the License or (at your option) version 3 or any later version
    accepted by the membership of KDE e.V. (or its successor approved
    by the membership of KDE e.V.), which shall act as a proxy
    defined in Section 14 of version 3 of the license.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program.  If not, see <http://www.gnu.org/licenses/>.
*/

#include "streamdirectoryentry.h"

streamDirectoryEntry::streamDirectoryEntry()
{
  parentItem = 0;
  self = this;
}

streamDirectoryEntry::~streamDirectoryEntry()
{
  foreach (streamDirectoryEntry *entry, childItems) {
    delete entry;
  };
}

int streamDirectoryEntry::childCount() const
{
  return childItems.size();
}

streamDirectoryEntry *streamDirectoryEntry::child(int row) const
{
  if (childItems.size() > row) {
    return childItems.value(row);
  } else {
    return 0;
  };
}

void streamDirectoryEntry::appendChild(streamDirectoryEntry *child)
{
  child->parentItem = this;
  childItems.append(child);
}

QVariant streamDirectoryEntry::rawData(const int column) const
{
  return data(column);
}

int streamDirectoryEntry::row() const
{
  if (parentItem) { // this is a child item
    return parentItem->childItems.indexOf(self);
  } else {  // this is a root item
    return 0;
  };
}

QVariant streamDirectoryEntry::data(const int) const
{
  return QVariant();
}

streamDirectoryEntry *streamDirectoryEntry::parent() const
{
  return parentItem;
}

QString streamDirectoryEntry::name() const
{
  return entryName;
}

void streamDirectoryEntry::setName(const QString & name)
{
  entryName = name;
}

KUrl streamDirectoryEntry::value() const
{
  return entryValue;
}

void streamDirectoryEntry::setValue(const KUrl & value)
{
  entryValue = value;
}

bool streamDirectoryEntry::canFetchMore() const
{
  return false;
}

void streamDirectoryEntry::fetchMore()
{
}
