#!/bin/sh
# (Re-)Generates the files that must have the version number of KRadioRipper.
# Expects the number as first argument.
# If the second argument is "stable", that a stable release is assumed.
# Than the version number is simply the number.
# Else the version number will be the number + "unstable".
SCRIPTDIR=`pwd`



echo "Setting version"

if [ "$2" = "stable" ]; # if second parameter is "stable"...
then DASHUNSTABLE=""
DOTUNSTABLE=""
CONFLICTS="  ";
else DASHUNSTABLE="-unstable"
DOTUNSTABLE=".unstable"
CONFLICTS="Conflicts:                    kradioripper  ";
fi

head --lines=2 ${SCRIPTDIR}/../templates/version.h.cmake > ${SCRIPTDIR}/../src/version.h.cmake
echo '' >> ${SCRIPTDIR}/../src/version.h.cmake
echo '/** \file' >> ${SCRIPTDIR}/../src/version.h.cmake
echo '  * This file is generated by the script <tt>set-version.sh</tt>.' >> ${SCRIPTDIR}/../src/version.h.cmake
echo '  * All changes you do to this file will be lost. */' >> ${SCRIPTDIR}/../src/version.h.cmake
tail --lines=+3 ${SCRIPTDIR}/../templates/version.h.cmake | sed -e "s/^#define VERSION.*$/#define VERSION \"$1${DOTUNSTABLE}\"/g" >> ${SCRIPTDIR}/../src/version.h.cmake

rm -f ${SCRIPTDIR}/../rpm/*.spec
head --lines=1 ${SCRIPTDIR}/../templates/template.spec > ${SCRIPTDIR}/../rpm/kradioripper${DASHUNSTABLE}-$1${DOTUNSTABLE}.spec
echo '# This file is generated by the script set-version.sh.' >> ${SCRIPTDIR}/../rpm/kradioripper${DASHUNSTABLE}-$1${DOTUNSTABLE}.spec
echo '# All changes you do to this file will be lost.' >> ${SCRIPTDIR}/../rpm/kradioripper${DASHUNSTABLE}-$1${DOTUNSTABLE}.spec
tail --lines=+2 ${SCRIPTDIR}/../templates/template.spec | sed -e "s/^Name:.*$/Name:                         kradioripper${DASHUNSTABLE}  /g" | sed -e "s/^Version:.*$/Version:                      $1${DOTUNSTABLE}  /g" | sed -e "s/^Conflicts:.*$/${CONFLICTS}/g" >> ${SCRIPTDIR}/../rpm/kradioripper${DASHUNSTABLE}-$1${DOTUNSTABLE}.spec

head --lines=1 ${SCRIPTDIR}/../templates/Doxyfile > ${SCRIPTDIR}/../apidoc/Doxyfile
echo '# This file is generated by the script set-version.sh.' >> ${SCRIPTDIR}/../apidoc/Doxyfile
echo '# All changes you do to this file will be lost.' >> ${SCRIPTDIR}/../apidoc/Doxyfile
tail --lines=+2 ${SCRIPTDIR}/../templates/Doxyfile | sed -e "s/^PROJECT_NUMBER.*$/PROJECT_NUMBER         = $1${DOTUNSTABLE}/g" >> ${SCRIPTDIR}/../apidoc/Doxyfile

head --lines=1 ${SCRIPTDIR}/../templates/index.html > ${SCRIPTDIR}/../apidoc/index.html
echo '<!--' >> ${SCRIPTDIR}/../apidoc/index.html
echo '    This file is generated by set-version.sh.' >> ${SCRIPTDIR}/../apidoc/index.html
echo '    All changes you do to this file will be lost.' >> ${SCRIPTDIR}/../apidoc/index.html
echo '-->' >> ${SCRIPTDIR}/../apidoc/index.html
tail --lines=+2 ${SCRIPTDIR}/../templates/index.html | sed -e "s/VERSION/version $1${DOTUNSTABLE}/g" >> ${SCRIPTDIR}/../apidoc/index.html

echo "Done setting version"
