/*
**************************************************************************
                                 description
                             --------------------
    copyright            : (C) 2000-2006 by Andreas Zehender
    email                : zehender@kde.org
**************************************************************************

**************************************************************************
*                                                                        *
*  This program is free software; you can redistribute it and/or modify  *
*  it under the terms of the GNU General Public License as published by  *
*  the Free Software Foundation; either version 2 of the License, or     *
*  (at your option) any later version.                                   *
*                                                                        *
**************************************************************************/


#include "pmerrordialog.h"
#include "pmerrorflags.h"

#include <klocale.h>
#include <KStandardGuiItem>
#include <qlabel.h>
#include <QTextEdit>
#include <QResizeEvent>

#include <kconfig.h>
#include <kdialog.h>
#include <kvbox.h>

QSize PMErrorDialog::s_size = QSize( 150, 200 );

PMErrorDialog::PMErrorDialog( const PMMessageList& messages, int errorFlags,
                              QWidget* parent )
      : KDialog( parent)
{
	setCaption( i18n( "Messages" ) );
	setButtons( Ok | Cancel );
	setDefaultButton( Ok );
   KVBox* page = new KVBox( this );
   setMainWidget( page );
   QLabel* text = new QLabel( QString( "" ), ( QWidget* )page );


   m_pTextView = new QTextEdit( ( QWidget* )page );
   m_pTextView->setReadOnly( true );

	m_messages = messages;
   displayMessages( );

   if( errorFlags & PMEWarning )
   {
      if( ( errorFlags & PMEError ) || ( errorFlags & PMEFatal ) )
         text->setText( i18n( "There were warnings and errors:" ) );
      else
         text->setText( i18n( "There were warnings:" ) );
   }
   else
      text->setText( i18n( "There were errors:" ) );

   setButtonGuiItem(Ok,  KGuiItem(KStandardGuiItem::ok().text(),
											 i18n( "Proceed" ),
											 i18n( "When clicking <b>Proceed</b>, the program\n"
													 "will try to proceed with the current action." )) );
   setButtonGuiItem(Cancel, KGuiItem(KStandardGuiItem::cancel().text(),
												 i18n( "&Cancel" ),
												 i18n( "When clicking <b>Cancel<b>, the program\n"
														 "will cancel the current action." ) ));

   if( errorFlags & PMEFatal )
      showButton(Ok, false );
   else
      new QLabel( i18n( "Still try to proceed?" ), ( QWidget* )page );

   resize( s_size );
}

void PMErrorDialog::displayMessages( )
{
	PMMessageList::ConstIterator it;
   QString text;

   text = "<qt>\n";

   for(it = m_messages.begin( ); it != m_messages.end( ); ++it )
      text += "<p>" + (*it).text( ) + "</p>\n";

   text += "</qt>";

   m_pTextView->setText( text );
}

void PMErrorDialog::saveConfig( KConfig* cfg )
{
   KConfigGroup cfgcg( cfg, "Appearance" );
   cfgcg.writeEntry( "ErrorDialogSize", s_size );
}

void PMErrorDialog::restoreConfig( KConfig* cfg )
{
   KConfigGroup cfgcg( cfg, "Appearance" );

   QSize defaultSize( 150, 200 );
   s_size = cfgcg.readEntry<QSize>( "ErrorDialogSize", defaultSize );
}

void PMErrorDialog::resizeEvent( QResizeEvent* ev )
{
   s_size = ev->size( );
}
#include "pmerrordialog.moc"
