/*
   Copyright (C) 2006 by Stefan Taferner <taferner@kde.org>

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2 of the License, or
   (at your option) any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/

/* settings.h
 */
#ifndef koverartist_settings_h
#define koverartist_settings_h

#include <qstring.h>
#include <qstringlist.h>


namespace KoverArtist
{


/** Global configuration options.
 */
class Settings
{
public:
   /** Access the global settings object. */
   static Settings* instance();

   /** Constructs a settings object. Use @ref instance to access the global
    * settings object.
    */
   Settings();

   /** Copy all (foreground/background) pictures into the project directory
    * and give them a unique name (like "project-fg.png").
    */
   bool localImages;

   /** Automatically remove black borders from left/right side of pictures. */
   bool removeImageBorders;

   /** Audio-CD device. */
   QString cdDevice;

   /** Server for CDDB requests. */
   QString cddbServer;

   /** Port for CDDB requests. */
   int cddbPort;

   /** Automatically set project title/subtitle from audiocd / cddb information
    * if title is empty.
    */
   bool cddbAutoSetTitle;

   /** List of directories that are searched for cddb entries. The first
    * directory in the list is used for storing downloaded cddb entries.
    */
   QStringList cddbDirs;

   /** Store cddb files locally in first directory of cddbDirs. */
   bool cddbCacheFiles;

   /** URL for cover image search. %1 will be replaced with the search string. */
   QString coverImageSearchUrl;

   /** Valid modes for cddb access. */
   enum CddbAccess { CDDB_LOCAL=1, CDDB_REMOTE, CDDB_ANY };
   CddbAccess cddbAccess;

   /** Store settings to the config file. */
   void sync();

protected:
   /** Load config settings. Called by the constructor. */
   void load();

private:
   Settings(const Settings&);
   Settings& operator=(const Settings&);

protected:
   static Settings* sInstance;
};


inline Settings* Settings::instance()
{
   if (!sInstance)
   {
      sInstance = new Settings();
      sInstance->load();
   }
   return sInstance;
}


} //namespace

#endif /*koverartist_settings_h*/
