/*
   Copyright (C) 2006 by Stefan Taferner <taferner@kde.org>

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2 of the License, or
   (at your option) any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/

#include "cddbchooser.h"

#include <qheader.h>
#include <qlabel.h>
#include <qlayout.h>
#include <qlistview.h>
#include <qvbox.h>



CddbChooser::CddbChooser(const QStringList& aValues, const QString& aCaption,
                         const QString& aDescription, QWidget* aParent)
:Inherited(aParent, "cddb-chooser", true, aCaption, Ok|Cancel, Ok)
{
   QVBox *box = new QVBox(this);
   QLabel *lbl;

   setMainWidget(box);

   lbl = new QLabel(aDescription, box);
   lbl->setFixedSize(lbl->sizeHint());

   mLstValues = new QListView(box);
   mLstValues->header()->hide();
   mLstValues->addColumn("Values");
   connect(mLstValues, SIGNAL(doubleClicked(QListViewItem*, const QPoint&, int)),
           this, SLOT(listItemActivated(QListViewItem*, const QPoint&, int)));

   QStringList::const_iterator it;
   for (it=aValues.begin(); it!=aValues.end(); ++it)
      new QListViewItem(mLstValues, *it);

   resize(sizeHint());
}


void CddbChooser::listItemActivated(QListViewItem*, const QPoint&, int)
{
   accept();
}


QString CddbChooser::currentItem() const
{
   QListViewItem *it = mLstValues->currentItem();
   if (it) return it->text(0);
   return QString::null;
}


#include "cddbchooser.moc"
