/***************************************************************************
 *   Copyright (C) 2006 by Conrad Hoffmann                                 *
 *   conrausch@gmx.de                                                      *
 *   http://conrausch.doesntexist.org                                      *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/


#include <kdebug.h>
#include <qlabel.h>
#include <qstring.h>
#include <qlayout.h>

#include <krootpixmap.h>
#include <kopetemetacontact.h>
#include <kopetegroup.h>

#include "kopetedesklistgroup.h"
#include "kopete_desklist.h"
#include "kopetedesklistitem.h"
#include "kopetedesklistrootwidget.h"

KopeteDesklistGroup::KopeteDesklistGroup( Kopete::Group* group, QWidget* parent, const char* name )
		: QLabel( parent, name ),
		m_group( group )
{
	m_isExpanded = m_group->isExpanded();

	/* create the label that displays the name */
	this->setFont( KopeteDesklistKcfg::groupLabelFont() );
	this->setPaletteForegroundColor( KopeteDesklistKcfg::groupLabelTextColor() );
	this->setText( getDisplayName() );
	KRootPixmap* krp = new KRootPixmap( this );
	krp->start();
}


KopeteDesklistGroup::~KopeteDesklistGroup()
{
}


void KopeteDesklistGroup::setExpanded( bool expanded )
{
	m_isExpanded = expanded;
	m_group->setExpanded( expanded );
	this->setText( getDisplayName() );
	emit stateChanged();
}


bool KopeteDesklistGroup::isExpanded()
{
	return m_isExpanded;
}


QString KopeteDesklistGroup::getDisplayName()
{
	QString pre = m_isExpanded ? QString::fromUtf8( "- " ) : QString::fromUtf8( "+ " );
	return pre.append( m_group->displayName() );
}


void KopeteDesklistGroup::mouseDoubleClickEvent( QMouseEvent* e )
{
	setExpanded( ! isExpanded() );
}


#include "kopetedesklistgroup.moc"
