//
// C++ Implementation: setupdialogprg
//
// Description: 
//
//
// Author: KoolDock team <radix@kde.cl>, (C) 2004
//
// Copyright: See COPYING file that comes with this distribution
//
//
#include <kfiledialog.h>
#include <kimageio.h>
#include <kicondialog.h>
#include <klocale.h>
#include <ksimpleconfig.h>
#include <kmessagebox.h>
#include <kstandarddirs.h>
#include <kpushbutton.h>
#include <keditlistbox.h>
#include <klineedit.h>
#include <qlistbox.h>

#include <qiconview.h>
#include <qdir.h>
#include <qstringlist.h>
#include <qtabwidget.h>

#include "setupdialog.h"
#include "setupdialogprg.h"
#include "apppropprg.h"
#include "appProp.h"
#include "kooldock.h"

SetupDialogPrg::SetupDialogPrg(QWidget *parent, const char *name)
: SetupDialog(parent, name)
{
   //Ignore list handlers
   grabbing=0;
   gwm=new KWinModule();
   connect(gwm, SIGNAL(activeWindowChanged(WId)), SLOT(activeWindowChanged(WId)));
   gwm->blockSignals(true);
   in=ignoreBox->lineEdit();
   //Remove useless buttons from widget
   up=ignoreBox->upButton();
   down=ignoreBox->downButton();
   up->hide();
   down->hide();
   //End ignore list handlers

   // some configuration variables
   progPath = locateLocal("data", "kooldock");
   menuPath = progPath + QString("/menu/");
		
   KConfig *config = KGlobal::config();
   config->setGroup("kooldock");
	
   toRestart->setChecked(false);
   appdlg=new appPropPrg();
   appdlg->user->setEnabled(false);
   appdlg->cuser->setChecked(false);
   appdlg->terminal->setChecked(false);
   appdlg->tclose->setChecked(false);
   appdlg->tclose->setEnabled(false);
   appTimer = new QTimer(this);
   connect(appTimer, SIGNAL(timeout()), this, SLOT(appRestart()));
   appTimer->start(15, FALSE);
   
   //Lets load the theme List
   KStandardDirs sys;
   QStringList bgPath = sys.findDirs("data", "kooldock/backgrounds");
   for(unsigned int i=0; i<bgPath.count();i++)
   {
      QDir tmpdir(bgPath[i]);
      QStringList theme_tmp(tmpdir.entryList(QDir::Dirs, QDir::Name));
      //We do it like this to avoid showing "." and ".." instead of copying QDir::entryList directly into "theme"
      for(unsigned int j=2; j<theme_tmp.count(); j++) theme->insertItem(theme_tmp[j]);
   }
}


void SetupDialogPrg::appRestart()
{
   if(!appdlg) return;
   if(appdlg->appRestart->isChecked())
   {
      appdlg->appRestart->setChecked(FALSE);
      kdDebug(0) << "Refresh applist" << endl;
      appClear();
      appFill();
   }
}


SetupDialogPrg::~SetupDialogPrg()
{
   if(appdlg) delete(appdlg);
   if(in) delete(in);
   kdDebug(0) << "Destroying..." << endl;
}


// Setup dialog implementation
void SetupDialogPrg::configOK()
{
   int fShowTaskbar=0;
   int fShowNotification=0;
   int fShowBorders=0;
   int fShowKMenu=0;
   int fHidden=0;
   int showNames=0;
   int fHideOnClick=0;
   int xinerama=0;
   int fhideTimer=5;
   int fShowNav=0;
   int fSystray=0;
   int fCurrent=0;
   

   //Stop grabbing window
   gwm->blockSignals(true);
   grabbing=0;
   grabWin->setText(i18n("Grab Window"));
   
   if (chk5->isChecked() == true) fShowTaskbar = 1;
   if (chk6->isChecked() == true) fShowNotification = 1;
   if (chk4->isChecked() == true) fShowBorders = 1;
   if (chk7->isChecked() == true) fShowKMenu = 1;
   if (chk1->isChecked() == true)
   {
      fHidden = 1;
      fhideTimer = hideTimer->value();
   }
   if (chk2->isChecked() == true) showNames = 1;
   if (hideOnClick->isChecked() == true) fHideOnClick = 1;
   if (xrma->isChecked() == true) xinerama=1;
   if (nav->isChecked()==true) fShowNav=1;
   if (systray->isChecked()==true) fSystray=1;
   if (currentDesk->isChecked()==true) fCurrent=1;
	
   kdDebug(0) << "Saving preferences..." << endl;
   KConfig *config = KGlobal::config();
   config->setGroup("kooldock");
   config->writeEntry("ShowTaskbar", fShowTaskbar);
   config->writeEntry("ShowNotification", fShowNotification);
   config->writeEntry("BorderColor", kColorCombo3->color().name());
   config->writeEntry("SmallIconSize", iwSmall->value());
   config->writeEntry("BigIconSize", iwBig->value());
   config->writeEntry("BackgroundColor", kColorCombo2->color().name());
   config->writeEntry("SeparatorColor", kColorCombo4->color().name());
   config->writeEntry("ShowKMenu", fShowKMenu);
   config->writeEntry("Hidden", fHidden);
   config->writeEntry("HideOnClick", fHideOnClick);
   config->writeEntry("Xinerama", xinerama);
   if(xinerama==1) config->writeEntry("leftRes", SleftRes->value());
   config->writeEntry("hideTimer", fhideTimer);
   config->writeEntry("Navigator", fShowNav);
   config->writeEntry("Systray", fSystray);
   config->writeEntry("currentDesktop", fCurrent);

   // kosd config
   config->writeEntry("showNames", showNames);
   config->writeEntry("xosdFont", xosdFont->currentText());
   config->writeEntry("xosdColor", kColorCombo1->color().name());
   config->writeEntry("xosdShadowColor", kColorCombo_shadow->color().name());
   config->writeEntry("xosdShadowOffset", spinBox2->value());
   config->writeEntry("xosdSize", xosdSize->value());
   if (xosdBold->isChecked())
   {
      config->writeEntry("xosdBold", 1);
   }
   else
   {
      config->writeEntry("xosdBold", 0);
   }
   if (xosdItalic->isChecked())
   {
      config->writeEntry("xosdItalic", 1);
   }
   else
   {
      config->writeEntry("xosdItalic", 0);
   }

   if (chkSshot->isChecked())
   {
      config->writeEntry("ShowSShot", TRUE);
   }
   else
   {
      config->writeEntry("ShowSShot", FALSE);
   }
   
   // save background configurations
   if (chkImg->isChecked())
   {
      //Lets find exactly where the selected theme is
      KStandardDirs sys;
      QString theme_dir="kooldock/backgrounds/"+theme->currentText();
      QStringList bgPath = sys.findDirs("data", theme_dir);
      
      //Lets set the images and write the config
      QString LeftImg=(QString)bgPath[0]+"background-left.png";
      QString CenterImg=(QString)bgPath[0]+"background-center.png";
      QString RightImg=(QString)bgPath[0]+"background-right.png";
      
      // background image enabled
      config->writeEntry("Solid", 0);
      config->writeEntry("Theme", theme->currentText());
      config->writeEntry("LeftImg", LeftImg);
      config->writeEntry("RightImg", RightImg);
      config->writeEntry("CenterImg", CenterImg);
      config->writeEntry("ShowBorders", 0);
      config->writeEntry("DockOpacity", 0);
   }
   else
   {
      // background image disabled
      config->writeEntry("Solid", 1);
      config->writeEntry("Theme", "");
      config->writeEntry("LeftImg", "");
      config->writeEntry("RightImg", "");
      config->writeEntry("CenterImg", "");
      config->writeEntry("ShowBorders", fShowBorders);
      config->writeEntry("DockOpacity", spinBox1->value());
   }
	
   config->sync();

   // write ignore list to file
   QString progPath = locateLocal("data", "kooldock");
   QString menuPath = progPath + QString("/menu/");
   QString filepath;
   filepath = QString(progPath + "/ignorelist.conf");
   if(ignoreBox->count()>0)
   {
      QFile out(filepath);
      if (out.open(IO_WriteOnly))
      {
         QTextStream out_s(&out);
         for(int i=0; i<ignoreBox->count(); i++)
         {
            out_s << ignoreBox->text(i) << "\n";
         }
         out.close();
      }
   }
   else
   {
      QFile::remove(filepath);
   }
   this->hide();
   debug("Restarting...");
   toRestart->setChecked(TRUE);
}

void SetupDialogPrg::configCancel()
{
   //Stop grabbing Windows
   gwm->blockSignals(true);
   grabWin->setText(i18n("Grab Window"));
   grabbing=0;
   this->hide();
   toRestart->setChecked(FALSE);
}

void SetupDialogPrg::closeEvent( QCloseEvent *e )
{
   e->ignore();
   configCancel();
}

void SetupDialogPrg::chkFont()
{
   bool tmp; //just to save some code
   
   if(chk2->isChecked())
   {
      tmp=true;
   }
   else
   {
      tmp=false;
   }
   xosdBold->setEnabled(tmp);
   xosdItalic->setEnabled(tmp);
   xosdSize->setEnabled(tmp);
   spinBox2->setEnabled(tmp);
   kColorCombo1->setEnabled(tmp);
   kColorCombo_shadow->setEnabled(tmp);
   xosdFont->setEnabled(tmp);
}


void SetupDialogPrg::xrma_clicked()
{
   if(xrma->isChecked()==true) SleftRes->setEnabled(true);
   if(xrma->isChecked()==false) SleftRes->setEnabled(false);
}

void SetupDialogPrg::chkTask()
{
   bool tmp;
   
   if(chk5->isChecked())
   {
      tmp=true;
   }
   else
   {
      tmp=false;
   }
   chk6->setEnabled(tmp);
   currentDesk->setEnabled(tmp);
   chkSshot->setEnabled(tmp);
}

void SetupDialogPrg::chkHidden()
{
   bool tmp;
   
   if(chk1->isChecked())
   {
      tmp=true;
   }
   else
   {
      tmp=false;
   }
   hideTimer->setEnabled(tmp);
   hideOnClick->setEnabled(tmp);
}


void SetupDialogPrg::chkSolidSlot()
{
   if (chkSolid->isChecked())
   {
      //Enable Solid Controls
      kColorCombo2->setEnabled(true);
      chk4->setEnabled(true);
      kColorCombo3->setEnabled(true);
      spinBox1->setEnabled(true);

      //Disable BackGround Images Controls
      chkImg->setChecked(false);
      theme->setEnabled(false);
   }
   else
   {
      chkImg->setChecked(true);
      chkImgSlot();
   }
}

void SetupDialogPrg::chkImgSlot()
{
   if (chkImg->isChecked())
   {
      //Disable Solid Controls
      chkSolid->setChecked(false);
      kColorCombo2->setEnabled(false);
      chk4->setEnabled(false);
      kColorCombo3->setEnabled(false);
      spinBox1->setEnabled(false);

      //Enable Backgroung Image Controls
      theme->setEnabled(true);
   }
   else
   {
      chkSolid->setChecked(true);
      chkSolidSlot();
   }
}


void SetupDialogPrg::applist_dropped(QDropEvent*e,const QValueList<QIconDragItem>&)
{
   KIconLoader icon_obj;
   QStringList lst;
   QString name;
   int pos;
   
   QUriDrag::decodeLocalFiles(e, lst);
   name=lst[0];

   //Lets see if it is a desktop file
   pos=name.findRev(".desktop", -1);
   if(pos!=-1)
   {
      KSimpleConfig *desktopfile;
      kdDebug(0) << "Desktop file dropped!" << endl;
      desktopfile = new KSimpleConfig(lst[0], TRUE);
      desktopfile->setGroup("Desktop Entry");
      appdlg->cmdname->setText(desktopfile->readEntry("Name"));
      appdlg->cmdpath->setText(desktopfile->readEntry("Exec"));
      appdlg->iconbutton->setIcon(desktopfile->readEntry("Icon"));
      delete(desktopfile);
   }
   else
   {
      //It was not a dekstop file, so lets create a new entry
      //Lets set a default name based on the program name
      pos=name.findRev("/", -1);
      if(pos!=-1)
      {
         name.remove(1, pos);
         name.remove("/", TRUE);
      }
	
      //Now we create and show the appProp dialog
      //appdlg=new appPropPrg();
      appdlg->cmdname->setText(name);
      appdlg->cmdpath->setText(lst[0]);
      
      //Based on the program name, lets try to set an icon; if it does
      //not exists, the system will set the "default" icon
      appdlg->iconbutton->setIcon(name);
   }
   appdlg->show();
}

void SetupDialogPrg::removeLauncher()
{
   if(fileName!=NULL)
   {
      QString question=i18n("Do you want to remove ") + fileName + QString("?");
      int remove = KMessageBox::questionYesNo(0, question, i18n("Remove Launcher"));
      if(remove!=KMessageBox::Yes) return;
      KSimpleConfig *desktopfile;
      QDir homeDir = QDir::home();

      if (homeDir.exists(progPath))
      {
         QDir dir(menuPath);
         QStringList fileListRemove;
         fileListRemove = dir.entryList("*.desktop");
         for ( QStringList::Iterator it = fileListRemove.begin(); it != fileListRemove.end(); ++it )
         {
            if ( ((*it) != ".") && ((*it) != "..") )
            {
               desktopfile = new KSimpleConfig( menuPath + (*it), TRUE);
               desktopfile->setGroup("Desktop Entry");
               if(desktopfile->readEntry("Name")==fileName)
               {
                  kdDebug(0) << "Removing " << menuPath + (*it) << endl;
                  delete(desktopfile);
                  if(QFile::remove(menuPath+(*it))==TRUE)
                  {
                     kdDebug(0) << "Item removed!" << endl;
                     
                     //Lets update the launchers index
                     QString preffix;
                     fileListRemove.clear();
                     fileListRemove=dir.entryList("*.desktop");
                     QStringList fileListRemove2=fileListRemove;
                     
                     //Not really sure why I couldn't do this within the other for, something like  fileListRemove[i].remove(0,2).prepend(preffix), but hell it works
                     for(unsigned int i=0; i<fileListRemove2.count(); i++)
                     {
                        fileListRemove2[i].remove(0,2);
                     }
                     
                     //Rename the files so they reflect their new position
                     for(unsigned int i=0; i<fileListRemove.count(); i++)
                     {
                        if(i<10) preffix=QString("0%1").arg(i);
                        if(i>=10) preffix=QString("%1").arg(i);
            
                        dir.rename(fileListRemove[i], QString("%1%2").arg(preffix).arg(fileListRemove2[i]));
                     }
                     //End updating
                     
                     appClear();
                     appFill();
                  }
                  else
                  {
                     kdDebug(0) << "Unable to remove file!" << endl;
                  }
                  return;
               }
               delete(desktopfile);
            }
         }
      }
   }
}


void SetupDialogPrg::grabWin_clicked()
{
   if(grabbing==0)
   {
      grabbing=1;
      grabWin->setText(i18n("Grabbing..."));
      gwm->blockSignals(false);
   }
   else
   {
      grabbing=0;
      grabWin->setText(i18n("Grab Window"));
      gwm->blockSignals(true);
   }
}


void SetupDialogPrg::activeWindowChanged(WId id)
{
   KWin::WindowInfo winfo;
   winfo=KWin::windowInfo(id);
   QString ninfo=winfo.visibleName();

   if(ninfo!=caption())
   {
      in->setText(ninfo);
   }
}

void SetupDialogPrg::buttonadd_clicked()
{
   appdlg->cmdpath->setText("");
   appdlg->cmdname->setText("");
   appdlg->iconbutton->setIcon("unknown");
   appdlg->show();
}

void SetupDialogPrg::showEvent(QShowEvent *)
{
   //Here we fill the applist
   appFill();
}

void SetupDialogPrg::appFill()
{
   // fill the application list.
   KSimpleConfig *desktopfile;
	
   QDir homeDir = QDir::home();
   KIconLoader icon_obj;
   QPixmap pixm;
	
   if(homeDir.exists(progPath))
   {
      QDir dir(menuPath);

      fileList.clear();
      fileList = dir.entryList("*.desktop");
      for ( QStringList::Iterator it = fileList.begin(); it != fileList.end(); ++it )
      {
         if ( ((*it) != ".") && ((*it) != "..") )
         {
            desktopfile = new KSimpleConfig( menuPath + (*it), TRUE);
            desktopfile->setGroup("Desktop Entry");
            QPixmap pixm=icon_obj.loadIcon(desktopfile->readEntry("Icon") ,KIcon::Desktop,0,KIcon::DefaultState,0L,false);
            new KIconViewItem(applist, desktopfile->readEntry("Name"), pixm);
            delete(desktopfile);
         }
      }
   }
}

void SetupDialogPrg::hideEvent ( QHideEvent * )
{
   // the application list is erased here.
   appClear();
}

void SetupDialogPrg::appClear()
{
   applist->clear();
}

void SetupDialogPrg::applist_contextMenuRequested(QIconViewItem *e,const QPoint&)
{
   if(e!=NULL)
   {
      KPopupMenu *popup=new KPopupMenu();
      KPopupMenu *setpos=new KPopupMenu();
 
      fileName=e->text();
      oldPos=e->index();
      connect(setpos, SIGNAL(activated(int)), this, SLOT(setnewpos(int)));
            
      //Load desktop data
      KSimpleConfig *desktopfile;
   
      QDir dir(menuPath);
      fileList.clear();
      fileList = dir.entryList("*.desktop");
      int i=0;
      for ( QStringList::Iterator it = fileList.begin(); it != fileList.end(); ++it )
      {
         if ( ((*it) != ".") && ((*it) != "..") )
         {
            desktopfile = new KSimpleConfig( menuPath + (*it), TRUE);
            desktopfile->setGroup("Desktop Entry");
            int menustate=setpos->insertItem(QString("%1").arg(desktopfile->readEntry("Name")),i);
            if(i==oldPos) setpos->setItemEnabled(menustate, false);
            delete(desktopfile);
            i++;
         }
      }
      //End Load
      
      popup->insertTitle(e->text());
      popup->insertItem(i18n("Swap with"), setpos);
      popup->insertItem(i18n("Remove"), this, SLOT(removeLauncher()));
      popup->exec(QCursor::pos());
      if(popup) delete(popup);
      if(setpos) delete(setpos);
   }
}


void SetupDialogPrg::setnewpos(int newpos)
{
   kdDebug(0) << "Not implemented... Soon!" << endl;
   kdDebug(0) << "New pos " << QString("0%1").arg(newpos) << "requested for: " << fileName<< endl;
   if(newpos==oldPos) return; //Nothing to be done
   computeNewPos(newpos);
}

void SetupDialogPrg::computeNewPos(int pos)
{
   QString preffix, preffix2;
   QDir dir(menuPath);
   
   fileList.clear();
   fileList = dir.entryList("*.desktop");
   
   //Lets remove the preffix of the files from fileList
   for(unsigned int i=0; i<fileList.count(); i++)
   {
      fileList[i]=fileList[i].remove(0,2);
   }
   
   //Preffix for old position
   if(oldPos<10) preffix=QString("0%1").arg(oldPos);
   if(oldPos>=10) preffix=QString("%1").arg(oldPos);

   //Preffix for new position
   if(pos<10) preffix2=QString("0%1").arg(pos);
   if(pos>=10) preffix2=QString("%1").arg(pos);
   
   kdDebug(0) << "Old Position: " << oldPos << endl;
   kdDebug(0) << "New Position: " << pos << endl;
   
   dir.rename(QString("%1%2").arg(preffix).arg(fileList[oldPos]), QString("%1%2").arg(preffix2).arg(fileList[oldPos]));
   dir.rename(QString("%1%2").arg(preffix2).arg(fileList[pos]), QString("%1%2").arg(preffix).arg(fileList[pos]));
   
   appClear();
   appFill();
}
#include "setupdialogprg.moc"
