/***************************************************************************
 *   Copyright (C) 2007-2009 by Thomas Thelliez <admin.kontrol@gmail.com>  *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as               *
 *   published by the Free Software Foundation; either version 2.0 of      *
 *   the License, or (at your option) any later version.                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU     *
 *   General Public License for more details.                              *
 *                                                                         *
 *   You should have received a copy of the GNU General Public             *
 *   License along with this program; if not, write to                     *
 *   the Free Software Foundation, Inc.,                                   *
 *   51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA          *
 ***************************************************************************/

#include "FileTransfertClientWidget.h"

FileTransfertClientWidget::FileTransfertClientWidget(int clientNbr, QLabel *pict, QStringList parameters, QWidget *parent)
        :nbr(clientNbr), params(parameters), QWidget(parent)
{

    remoteFilesIconList = new QList<QStandardItem *>();
    QGroupBox *remoteGroupBox = new QGroupBox(tr("Remote available files"), this);
    QGroupBox *localGroupBox = new QGroupBox(tr("Local available files"), this);
    QGridLayout *remoteGridBox = new QGridLayout;
    QGridLayout *localGridBox = new QGridLayout;
    QLabel *serverHowTo = new QLabel(tr("Select a local file below and click \">\" to send the file into the client workstation."));
    QLabel *clientHowTo = new QLabel(tr("Select a remote file below and click \"<\" to upload the file into the server."));
    remotePath = new QLabel(tr("Loading..."), this);

    #ifdef WIN32
    QDir filesDir(QDir::toNativeSeparators(QDir::homePath()) + "\\KontrolPack\\Files");
    localPath = new QLabel("<b>" + QDir::toNativeSeparators(QDir::homePath()) + "\\KontrolPack\\Files\\</b>");
    localStringPath = QDir::toNativeSeparators(QDir::homePath()) + "\\KontrolPack\\Files\\";
    #elif defined (linux)
    QDir filesDir(QDir::toNativeSeparators(QDir::homePath()) + "/KontrolPack/Files");
    localPath = new QLabel("<b>" + QDir::toNativeSeparators(QDir::homePath()) + "/KontrolPack/Files/</b>");
    localStringPath = QDir::toNativeSeparators(QDir::homePath()) + "/KontrolPack/Files/";
    #elif defined __APPLE__
    QDir filesDir(QDir::toNativeSeparators(QDir::homePath()) + "/KontrolPack/Files");
    localPath = new QLabel("<b>" + QDir::toNativeSeparators(QDir::homePath()) + "/KontrolPack/Files/</b>");
    localStringPath = QDir::toNativeSeparators(QDir::homePath()) + "/KontrolPack/Files/";
    #endif
    localFilesList = filesDir.entryList(QDir::Files, QDir::Name);
    remoteList = new QListCyborgWidget;
    localList = new QListCyborgWidget;
    remoteGridBox->addWidget(clientHowTo, 0, 0);
    remoteGridBox->addWidget(remotePath, 1, 0);
    remoteGridBox->addWidget(remoteList, 2, 0);

    QPushButton *browseLocalButton = new QPushButton(tr("Browse directory"), this);
    localGridBox->addWidget(serverHowTo, 0, 0);
    localGridBox->addWidget(browseLocalButton, 1, 0);
    localGridBox->addWidget(localPath, 2, 0);
    localGridBox->addWidget(localList, 3, 0);
    localGroupBox->setLayout(localGridBox);
    remoteGroupBox->setLayout(remoteGridBox);

    remoteFilesIconModel = new QStandardItemModel(this);
    localFilesModel = new QStringListModel(localFilesList);
    
    QList<QStandardItem *> localFilesIconList = QList<QStandardItem *>();
    QStandardItemModel *fileModel = new QStandardItemModel(this);

    iconprovider  = new QFileIconProvider();
    for (int k = 0; k < localFilesList.size(); k++) {
        QStandardItem *item = new QStandardItem(iconprovider->icon(QFileInfo(localStringPath + localFilesList.at(k))) ,localFilesList.at(k));
        item->setEditable (false);
        fileModel->appendRow(item);
    }
    fileModel->appendRow(localFilesIconList);
    localList->setModel(fileModel);
    localList->setIconSize(QSize(22, 22));

    remoteList->setModel(remoteFilesIconModel);
    remoteList->setIconSize(QSize(22, 22));
	
	
    getButton = new QPushButton(tr("<"), this);
    sendButton = new QPushButton(tr(">"), this);
    connect(getButton, SIGNAL(clicked()), this, SLOT(clicRemoteFileSelection()));
    connect(sendButton, SIGNAL(clicked()), this, SLOT(clicLocalFileSelection()));
    connect(browseLocalButton, SIGNAL(clicked()), this, SLOT(openFolderDialog()));
    connect(remoteList, SIGNAL(doubleClicked(QModelIndex)), this, SLOT(doubleClicFolder()));
    QGridLayout *buttonLayout = new QGridLayout;
    buttonLayout->addWidget(getButton, 0, 0);
    buttonLayout->addWidget(sendButton, 1, 0);
    QGridLayout *layout = new QGridLayout;
    layout->addWidget(localGroupBox, 0, 0);
    layout->addLayout(buttonLayout, 0, 1);
    layout->addWidget(remoteGroupBox, 0, 2);
    setLayout(layout);
}

void FileTransfertClientWidget::clicRemoteFileSelection()
{
    getButton->setDisabled(true);
    sendButton->setDisabled(true);
    QItemSelectionModel *selection = remoteList->selectionModel();
    QModelIndex indexElementSelectionne = selection->currentIndex();
    QStringListModel *listModel = (QStringListModel*)remoteList->model();
    QVariant elementSelectionne = listModel->data(indexElementSelectionne, Qt::DisplayRole);
    if (QString::compare(elementSelectionne.toString(), "", Qt::CaseSensitive) == 0)
    {
        getButton->setDisabled(false);
        sendButton->setDisabled(false);
        QMessageBox::information(this, tr("Warning"), tr("Please, select a remote file int the right list"));
    } else
    {
      //  int choice = QMessageBox::question(this, tr("Upload remote file from remote workstation to this computer"), "The following file will be uploaded to this computer : <br /><br />" + elementSelectionne.toString());
        QString fileToGet = elementSelectionne.toString();
        for (int i = 0; i < localFilesList.size(); i++) {
            QString fileName = localFilesList.at(i);
            if (QString::compare(fileName, fileToGet, Qt::CaseInsensitive) == 0)
            {
                getButton->setDisabled(false);
                sendButton->setDisabled(false);
                QMessageBox::information(this, tr("Warning"), tr("This file already exists locally, delete it, change dir or choose another file."));
                return;
            }
        }
        for (int j = 0; j < remoteFoldersList.size(); j++) {
            QString folderName = remoteFoldersList.at(j);
            if (QString::compare(folderName, fileToGet, Qt::CaseInsensitive) == 0)
            {
                getButton->setDisabled(false);
                sendButton->setDisabled(false);
                QMessageBox::information(this, tr("Warning"), tr("You cannot share folders between workstations, only file. Choose a file or double click on folders to change remote directory."));
                return;
            }
        }
        emit getFileFromRemoteClient(fileToGet, nbr);
    }
}

void FileTransfertClientWidget::doubleClicFolder()
{
    QItemSelectionModel *selection = remoteList->selectionModel();
    QModelIndex indexElementSelectionne = selection->currentIndex();
    QStringListModel *listModel = (QStringListModel*)remoteList->model();
    QVariant elementSelectionne = listModel->data(indexElementSelectionne, Qt::DisplayRole);
	QString selectedDocument = elementSelectionne.toString();
	for (int j = 0; j < remoteFoldersList.size(); j++) {
                QString folderName = remoteFoldersList.at(j);
		if (QString::compare(folderName, selectedDocument, Qt::CaseInsensitive) == 0)
		{
			emit changeDirectory("cd " + selectedDocument, nbr);
			return;
		}
	}
}

void FileTransfertClientWidget::refreshFilesList()
{
    QDir filesDir(localStringPath);
    localFilesList = filesDir.entryList(QDir::Files, QDir::Name);
    QStandardItemModel *fileModel = new QStandardItemModel(this);

        for (int k = 0; k < localFilesList.size(); k++) {
            QIcon icon  = iconprovider->icon(QFileInfo(localStringPath + localFilesList.at(k)));
            if (icon.isNull()) {
                icon = QIcon(":/icons/file.png");
            }
            QStandardItem *item = new QStandardItem(icon ,localFilesList.at(k));
            item->setEditable (false);
            fileModel->appendRow(item);
        }
    localList->setModel(fileModel);
}

void FileTransfertClientWidget::fileSent(int clientNbr)
{
    refreshFilesList();
    sendButton->setDisabled(false);
    getButton->setDisabled(false);
}

void FileTransfertClientWidget::fileUploaded(int clientNbr)
{
    refreshFilesList();
    sendButton->setDisabled(false);
    getButton->setDisabled(false);
}

void FileTransfertClientWidget::clicLocalFileSelection()
{
    sendButton->setDisabled(true);
    getButton->setDisabled(true);
    QItemSelectionModel *selection = localList->selectionModel();
    QModelIndex indexElementSelectionne = selection->currentIndex();
    QStringListModel *listModel = (QStringListModel*)localList->model();
    QVariant elementSelectionne = listModel->data(indexElementSelectionne, Qt::DisplayRole);
    if (QString::compare(elementSelectionne.toString(), "", Qt::CaseSensitive) == 0)
    {
        sendButton->setDisabled(false);
        getButton->setDisabled(false);
        QMessageBox::information(this, tr("Warning"), tr("Please, select a local file in the left list"));
    } else
    {
     if (true) {
            QString fileToSend = elementSelectionne.toString();

            for (int i = 0; i < remoteFilesList.size(); i++) {
                QString fileName = remoteFilesList.at(i);
                if (QString::compare(fileName, fileToSend, Qt::CaseInsensitive) == 0)
                {
                    sendButton->setDisabled(false);
                    getButton->setDisabled(false);
                    QMessageBox::information(this, tr("Warning"), tr("This file already exists remotely, delete it, change dir or choose another file."));
                    return;
                }
            }
            QFile f(localStringPath + elementSelectionne.toString());
            if (!f.exists()) {
                sendButton->setDisabled(false);
                getButton->setDisabled(false);
                refreshFilesList();
                QMessageBox::information(this, tr("Warning"), tr("This file does not exists anymore."));
                return;
            }
            QByteArray bytes;
            if (!f.open(QIODevice::ReadOnly))
            {
                return;
            }
            bool readable = f.isReadable();
            while (!f.atEnd())
            {
                bytes = f.readAll();
            }
            f.close();
            int size = bytes.size();
            if (readable)
             {
                if (size > 50000000) {
                    sendButton->setDisabled(false);
                    getButton->setDisabled(false);
                    QMessageBox::information(this, tr("Warning"), tr("This version does not allow transfer for file size > to 50Mo."));
                } else {
                    emit sendFileToRemoteClient(localStringPath + fileToSend, nbr);
                }
            }
             else {
                sendButton->setDisabled(false);
                getButton->setDisabled(false);
                QMessageBox::information(this, tr("Warning"), tr("You don't have read permission on this file, sorry."));
            }
        }
    }
}

void FileTransfertClientWidget::openFolderDialog()
{
    QString directory = QFileDialog::getExistingDirectory(this);
    if (QString::compare(directory, "", Qt::CaseSensitive) != 0)
    {
        QDir filesDir(QDir::toNativeSeparators(directory));

        QStandardItemModel *fileModel = new QStandardItemModel(this);
        localFilesList = filesDir.entryList(QDir::Files, QDir::Name);
        for (int k = 0; k < localFilesList.size(); k++) {
            QIcon icon  = iconprovider->icon(QFileInfo(localStringPath + localFilesList.at(k)));
            if (icon.isNull()) {
                icon = QIcon(":/icons/file.png");
            }
            QStandardItem *item = new QStandardItem(icon ,localFilesList.at(k));
            item->setEditable (false);
            fileModel->appendRow(item);
        }
        localList->setModel(fileModel);
    #ifdef WIN32
        localStringPath = directory + "\\";
    #elif defined (linux)
       localStringPath = directory + "/";
    #elif defined __APPLE__
       localStringPath = directory + "/";
    #endif

        localPath->setText("<b>" + directory + "/</b>");
    }
}

