/***************************************************************************
 *   Copyright (C) 2007-2009 by Thomas Thelliez <admin.kontrol@gmail.com>  *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as               *
 *   published by the Free Software Foundation; either version 2.0 of      *
 *   the License, or (at your option) any later version.                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU     *
 *   General Public License for more details.                              *
 *                                                                         *
 *   You should have received a copy of the GNU General Public             *
 *   License along with this program; if not, write to                     *
 *   the Free Software Foundation, Inc.,                                   *
 *   51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA          *
 ***************************************************************************/

#include <QGridLayout>
#include <QLabel>
#include <QLineEdit>
#include <QPushButton>
#include <QHBoxLayout>
#include <QMessageBox>
#include <QIcon>
#include <QMap>

/*class PingDialog : public QDialog
{
  Q_OBJECT
public:
    QLabel *pingLabel;
    QLineEdit *ping;
    QString os;
  PingDialog(QString operatingSystem)
          :os(operatingSystem)
  {
    pingLabel = new QLabel(tr("Host to ping : "), this);
    ping =  new QLineEdit(this);
    QPushButton *button = new QPushButton(tr("Execute"));

    connect(button, SIGNAL(clicked()), this, SLOT(onClic()));
    QHBoxLayout* layout = new QHBoxLayout();
    layout->addWidget(pingLabel);
    layout->addWidget(ping);
    layout->addWidget(button);
    setLayout(layout);
  }
private slots:
void onClic()
  {
    if (os.startsWith(QString("LINUX"), Qt::CaseInsensitive))
    {
        emit executeCommand("ping " + ping->text());
    }
    else if (os.startsWith("WINDOWS", Qt::CaseInsensitive))
    {
            emit executeCommand("ping " + ping->text());
    }
    else if (os.startsWith("MACOSX", Qt::CaseInsensitive))
    {
            emit executeCommand("ping " + ping->text());
    }
    hide();
  }
signals:
    void executeCommand(QString command);
};*/

class DelFileDialog : public QDialog
{
  Q_OBJECT
public:
    QLabel *fileNameLabel;
    QLineEdit *fileName;
    QString os;
  DelFileDialog(QString operatingSystem)
          :os(operatingSystem)
  {
    fileNameLabel = new QLabel(tr("File name to delete : "), this);
    fileName =  new QLineEdit(this);
    QPushButton *button = new QPushButton(tr("Execute"));

    connect(button, SIGNAL(clicked()), this, SLOT(onClic()));
    QHBoxLayout* layout = new QHBoxLayout();
    layout->addWidget(fileNameLabel);
    layout->addWidget(fileName);
    layout->addWidget(button);
    setLayout(layout);
  }
private slots:
void onClic()
  {
    if (os.startsWith(QString("LINUX"), Qt::CaseInsensitive))
    {
        emit executeCommand("rm " + fileName->text().replace(QString(" "), QString("\\ ")));
    }
    else if (os.startsWith("WINDOWS", Qt::CaseInsensitive))
    {
            emit executeCommand("DEL \"" + fileName->text() + "\"");
    }
    else if (os.startsWith("MACOSX", Qt::CaseInsensitive))
    {
            emit executeCommand("rm " + fileName->text().replace(QString(" "), QString("\\ ")));
    }
    hide();
  }
signals:
    void executeCommand(QString command);
};

class DelDirDialog : public QDialog
{
  Q_OBJECT
public:
    QLabel *folderNameLabel;
    QLineEdit *folderName;
    QString os;
  DelDirDialog(QString operatingSystem)
          :os(operatingSystem)
  {
    folderNameLabel = new QLabel(tr("Folder name to delete : "), this);
    folderName =  new QLineEdit(this);
    QPushButton *button = new QPushButton(tr("Execute"));

    connect(button, SIGNAL(clicked()), this, SLOT(onClic()));
    QHBoxLayout* layout = new QHBoxLayout();
    layout->addWidget(folderNameLabel);
    layout->addWidget(folderName);
    layout->addWidget(button);
    setLayout(layout);
  }
private slots:
void onClic()
  {
    if (os.startsWith(QString("LINUX"), Qt::CaseInsensitive))
    {
        emit executeCommand("rm -rf " + folderName->text().replace(QString(" "), QString("\\ ")));
    }
    else if (os.startsWith("WINDOWS", Qt::CaseInsensitive))
    {
            emit executeCommand("RMDIR \"" + folderName->text() + "\"");
    }
    else if (os.startsWith("MACOSX", Qt::CaseInsensitive))
    {
            emit executeCommand("rm -rf " + folderName->text().replace(QString(" "), QString("\\ ")));
    }
    hide();
  }
signals:
    void executeCommand(QString command);
};

class MkDirDialog : public QDialog
{
  Q_OBJECT
public:
    QLabel *folderNameLabel;
    QLineEdit *folderName;
    QString os;
  MkDirDialog(QString operatingSystem)
          :os(operatingSystem)
  {
    folderNameLabel = new QLabel(tr("Folder name : "), this);
    folderName =  new QLineEdit(this);
    QPushButton *button = new QPushButton(tr("Execute"));

    connect(button, SIGNAL(clicked()), this, SLOT(onClic()));
    QHBoxLayout* layout = new QHBoxLayout();
    layout->addWidget(folderNameLabel);
    layout->addWidget(folderName);
    layout->addWidget(button);
    setLayout(layout);
  }
private slots:
void onClic()
  {
    if (os.startsWith(QString("LINUX"), Qt::CaseInsensitive))
    {
        emit executeCommand("mkdir " + folderName->text().replace(QString(" "), QString("\\ ")));
    }
    else if (os.startsWith("WINDOWS", Qt::CaseInsensitive))
    {
            emit executeCommand("MKDIR \"" + folderName->text() + "\"");
    }
    else if (os.startsWith("MACOSX", Qt::CaseInsensitive))
    {
            emit executeCommand("mkdir " + folderName->text().replace(QString(" "), QString("\\ ")));
    }
    hide();
  }
signals:
    void executeCommand(QString command);
};

class CopyDialog : public QDialog
{
  Q_OBJECT
public:
    QLabel *fromLabel;
    QLabel *toLabel;
    QLineEdit *from;
    QLineEdit *to;
    QString os;
  CopyDialog(QString operatingSystem)
          :os(operatingSystem)
  {
    fromLabel = new QLabel(tr("Copy From : "), this);
    toLabel = new QLabel(tr("To :"), this);
    from =  new QLineEdit(this);
    to = new QLineEdit(this);
    QPushButton *button = new QPushButton(tr("Execute"));

    connect(button, SIGNAL(clicked()), this, SLOT(onClic()));
    QHBoxLayout* layout = new QHBoxLayout();
    layout->addWidget(fromLabel);
    layout->addWidget(from);
    layout->addWidget(toLabel);
    layout->addWidget(to);
    layout->addWidget(button);
    setLayout(layout);
  }
private slots:
void onClic()
  {
    if (os.startsWith(QString("LINUX"), Qt::CaseInsensitive))
    {
        emit executeCommand("cp -a " + from->text().replace(QString(" "), QString("\\ ")) + " " + to->text().replace(QString(" "), QString("\\ ")));
    }
    else if (os.startsWith("WINDOWS", Qt::CaseInsensitive))
    {
            emit executeCommand("COPY \"" + from->text() + "\" \"" + to->text() + "\"");
    }
    else if (os.startsWith("MACOSX", Qt::CaseInsensitive))
    {
            emit executeCommand("cp -a " + from->text().replace(QString(" "), QString("\\ ")) + " " + to->text().replace(QString(" "), QString("\\ ")));
    }
    hide();
  }
signals:
    void executeCommand(QString command);
};

class DefinedCommand : public QWidget
{
    Q_OBJECT

public:
    DefinedCommand(QString operatingSystem);
    QString os;
    QPushButton *copyButton;
    QPushButton *mkDirButton;
    QPushButton *setButton;
    QPushButton *delFileButton;
    QPushButton *delFolderButton;
    QPushButton *shutdownButton;
    QPushButton *ipconfigButton;
    QPushButton *pingButton;
    QPushButton *networkStatsButton;
    QPushButton *routeTableButton;
public slots:
    void copyAction();
    void mkDirAction();
    void setAction();
    void delFileAction();
    void delFolderAction();
    void shutdownAction();
    void ipconfigAction();
    void networkStatsAction();
    void pingAction();
    void routeTableAction();
    void executeDefinedCommand(QString command);

signals:
    void executeCommand(QString command);

private:
	
};
