/***************************************************************************
 *   Copyright (C) 2007-2009 by Thomas Thelliez <admin.kontrol@gmail.com>  *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as               *
 *   published by the Free Software Foundation; either version 2.0 of      *
 *   the License, or (at your option) any later version.                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU     *
 *   General Public License for more details.                              *
 *                                                                         *
 *   You should have received a copy of the GNU General Public             *
 *   License along with this program; if not, write to                     *
 *   the Free Software Foundation, Inc.,                                   *
 *   51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA          *
 ***************************************************************************/

#include "XmlResultsParser.h"

XmlResultsParser::XmlResultsParser(QObject *parent)
         : QObject(parent)
{
    folderList = QStringList();
    parametersList = QStringList();
}

QStringList XmlResultsParser::getClientParametersFromXml(QString buffer)
{
    folderList.clear();
    parametersList.clear();
    QDomDocument doc;
    doc.setContent(buffer);
    QDomElement root = doc.documentElement();
    QDomElement child = root.firstChild().toElement();
    while(!child.isNull())
    {
        if (child.tagName() == HOSTNAME)
        {
          parametersList.append(child.text());
        }
        else if (child.tagName() == SYSTEM)
        {
            parametersList.append(child.text());
        }
        if (child.tagName() == PATH)
        {
          folderList.append(child.text());
        }
        if (child.tagName() == FILE_INDEX)
        {
          folderList.append(child.text());
        }
        else if (child.tagName() == FOLDER_LIST)
        {
            QDomElement folderChild = child.firstChild().toElement();
            while(!folderChild.isNull())
            {
                if (folderChild.tagName() == FOLDER)
                {
                  folderList.append(folderChild.text());
                }
                folderChild = folderChild.nextSibling().toElement();
            }
        } else if (child.tagName() == FILE_LIST)
        {
            QDomElement fileChild = child.firstChild().toElement();
            while(!fileChild.isNull())
            {
                if (fileChild.tagName() == FILE_XML)
                {
                  folderList.append(fileChild.text());
                }
                fileChild = fileChild.nextSibling().toElement();
            }
        } else if (child.tagName() == IP_LIST)
        {
            QDomElement ipChild = child.firstChild().toElement();
            while(!ipChild.isNull())
            {
                if (ipChild.tagName() == IP)
                {
                  parametersList.append(ipChild.text());
                }
                ipChild = ipChild.nextSibling().toElement();
            }
        }
        child = child.nextSibling().toElement();
      }
      setList(folderList);
      return parametersList;
}

QStringList XmlResultsParser::parseXmlForCommandContext(QString xml)
{
    folderList.clear();
    QDomDocument doc;
    doc.setContent(xml);
    QDomElement root = doc.documentElement();
    QDomElement child = root.firstChild().toElement();
    while(!child.isNull())
    {
        if (child.tagName() == PATH)
        {
          folderList.append(child.text());
        }
        if (child.tagName() == FILE_INDEX)
        {
          folderList.append(child.text());
        }
        else if (child.tagName() == FILE_LIST)
        {
            QDomElement fileChild = child.firstChild().toElement();
            while(!fileChild.isNull())
            {
                if (fileChild.tagName() == FILE_XML)
                {
                  folderList.append(fileChild.text());
                }
                fileChild = fileChild.nextSibling().toElement();
            }
        } else if (child.tagName() == FOLDER_LIST)
        {
            QDomElement folderChild = child.firstChild().toElement();
            while(!folderChild.isNull())
            {
                if (folderChild.tagName() == FOLDER)
                {
                  folderList.append(folderChild.text());
                }
                folderChild = folderChild.nextSibling().toElement();
            }
        }
        child = child.nextSibling().toElement();
      }
      return folderList;
}

QStringList XmlResultsParser::getFilePathFromXml(QString buffer)
{
    QStringList list = QStringList();
    QDomDocument doc;
    doc.setContent(buffer);
    QDomElement root = doc.documentElement();
    QDomElement child = root.firstChild().toElement();
    while(!child.isNull())
    {
        if (child.tagName() == FILE_NAME)
        {
          list.append(child.text());
        }
        else if (child.tagName() == FILE_SIZE)
        {
          list.append(child.text());
        }
        else if (child.tagName() == READABLE)
        {
          list.append(child.text());
        }
        child = child.nextSibling().toElement();
      }
      return list;
}

QString XmlResultsParser::getFileTransferedOnRemoteClientfromXml(QString xml)
{
    QString filePath;
    QDomDocument doc;
    doc.setContent(xml);
    QDomElement root = doc.documentElement();
    QDomElement child = root.firstChild().toElement();
    while(!child.isNull())
    {
        if (child.tagName() == FILE_PATH)
        {
          filePath = child.text();
        }
        child = child.nextSibling().toElement();
      }
      return filePath;
}

QString XmlResultsParser::getVersion(QString xml)
{
    QString version = "";
    QDomDocument doc;
    doc.setContent(xml);
    QDomElement root = doc.documentElement();
    QDomElement child = root.firstChild().toElement();
    while(!child.isNull())
    {
        if (child.tagName() == VERSION_LABEL)
        {
          version = child.text();
        }
        child = child.nextSibling().toElement();
      }
      return version;
}

void XmlResultsParser::setList(QStringList list)
{
    parameters = list;
}

QStringList XmlResultsParser::getList()
{
    return parameters;
}
