/***************************************************************************
 *   Copyright (C) 2007-2009 by Thomas Thelliez <admin.kontrol@gmail.com>  *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as               *
 *   published by the Free Software Foundation; either version 2.0 of      *
 *   the License, or (at your option) any later version.                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU     *
 *   General Public License for more details.                              *
 *                                                                         *
 *   You should have received a copy of the GNU General Public             *
 *   License along with this program; if not, write to                     *
 *   the Free Software Foundation, Inc.,                                   *
 *   51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA          *
 ***************************************************************************/

#include <QWidget>
#include <QHttp>
#include <QUrl>
#include <QGridLayout>
#include <QLabel>
#include <QPushButton>
#include <QVBoxLayout>
#include <QMessageBox>
#include "server/core/communication/XmlResultsParser.h"
#include "main/common/xml_constants.h"

class UpdateDialog : public QDialog
{
  Q_OBJECT
public:
    QLabel *label;
    QString versionWeb;
  UpdateDialog(QString version)
          :versionWeb(version)
  {
    label = new QLabel(tr("A new KontrolPack release : version ") + versionWeb + tr(" is now available on KontrolPack Web site."), this);
    QLabel *creatorLabel = new QLabel(tr("KontrolPack web site : <a href=\"http://www.kontrolpack.com/\">http://www.kontrolpack.com/</a><br/><br/>"), this);
    creatorLabel->setOpenExternalLinks(true);
    QPushButton *button = new QPushButton(tr("Close"));
    this->setWindowTitle(tr("New KontrolPack available"));
    connect(button, SIGNAL(clicked()), this, SLOT(onClic()));
    QVBoxLayout* layout = new QVBoxLayout();
    layout->addWidget(label);
    layout->addWidget(creatorLabel);
    layout->addWidget(button);
    setLayout(layout);
  }
private slots:
void onClic()
  {
    hide();
  }
};

class UpdateManager : public QWidget
{
    Q_OBJECT

public:
        UpdateManager();
        XmlResultsParser *xmlResultsParser;
        QHttp *http;
public slots:
    void readVersion();
    void updateManager();
protected:


};

