/***************************************************************************
 *   Copyright (C) 2007-2009 by Thomas Thelliez <admin.kontrol@gmail.com>  *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as               *
 *   published by the Free Software Foundation; either version 2.0 of      *
 *   the License, or (at your option) any later version.                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU     *
 *   General Public License for more details.                              *
 *                                                                         *
 *   You should have received a copy of the GNU General Public             *
 *   License along with this program; if not, write to                     *
 *   the Free Software Foundation, Inc.,                                   *
 *   51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA          *
 ***************************************************************************/

#include <QApplication>
#include <QtGui>
#include "server/ui/MainWindow.h"
#include "server/ui/ServerDialog.h"
#include "datastore/XmlDataStore.h"
#include "client/ClientMainWidget.h"
#include "startup/StartUpDialog.h"
#include "startup/UpdateManager.h"

#define SERVER_MODE 0
#define CLIENT_MODE 1
#define NONE_MODE 2

int main(int argc, char *argv[])
{
    Q_INIT_RESOURCE(resources);
    QApplication app(argc, argv);
    //QTextCodec::setCodecForCStrings(QTextCodec::codecForName("Latin1"));
    QString locale = QLocale::system().name().section('_', 0, 0);

    QTranslator translator;
    translator.load(QString("KontrolPack_") + locale);
    app.installTranslator(&translator);

    UpdateManager *updateManager = new UpdateManager();
    QTimer::singleShot(10000, updateManager, SLOT(updateManager()));
    new XmlDataStore();
    QString mode = XmlDataStore::getStartUpMode();
    if (mode.startsWith("NONE", Qt::CaseSensitive))
    {
            StartUpDialog *startUpDialog = new StartUpDialog();
            #ifdef WIN32
            startUpDialog->setAttribute(Qt::WA_TranslucentBackground, true);
            startUpDialog->setWindowFlags(Qt::FramelessWindowHint);
            #elif defined (linux)
            startUpDialog->setWindowFlags(Qt::FramelessWindowHint);
            #elif defined __APPLE__
            startUpDialog->setAttribute(Qt::WA_TranslucentBackground, true);
            startUpDialog->setWindowFlags(Qt::FramelessWindowHint);
            #endif
            startUpDialog->show();
    }
    else if (mode.startsWith("SERVER", Qt::CaseSensitive))
    {
            MainWindow *window = new MainWindow;
            ServerDialog *serverSettingsDialog = new ServerDialog();
            QObject::connect(serverSettingsDialog, SIGNAL(startedServer(QString, QString)), window, SLOT(startedServer(QString, QString)));
            QObject::connect(window, SIGNAL(showServerSettingsDialog()), serverSettingsDialog, SLOT(showServerSettingsDialog()));
            window->showMaximized();
            serverSettingsDialog->exec();
    }
    else if (mode.startsWith("CLIENT", Qt::CaseSensitive))
    {
            ClientMainWidget *client = new ClientMainWidget;
            client->show();
            QStringList list = XmlDataStore::getClientIp();
            if (list.at(1).startsWith("true", Qt::CaseInsensitive)) {
                client->clientShell->autoConnect();
            }
    }
    return app.exec();
}
