/***************************************************************************
 *   Copyright (C) 2007-2009 by Thomas Thelliez <admin.kontrol@gmail.com>  *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as               *
 *   published by the Free Software Foundation; either version 2.0 of      *
 *   the License, or (at your option) any later version.                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU     *
 *   General Public License for more details.                              *
 *                                                                         *
 *   You should have received a copy of the GNU General Public             *
 *   License along with this program; if not, write to                     *
 *   the Free Software Foundation, Inc.,                                   *
 *   51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA          *
 ***************************************************************************/

#ifndef HEADER_XMLDATASTORE
#define HEADER_XMLDATASTORE

#include <QString>
#include <QDir>
#include <QObject>
#include <QtXml>
#include <QStringList>
#include <QTextStream>


class XmlDataStore : public QObject
 {
     Q_OBJECT

    public:
        XmlDataStore();
        static void saveFilteredIpsData(QStringList data);
        static QStringList getFilteredIpsData();
        static void saveStartUpMode(QString mode);
        static QString getStartUpMode();
        static QString transformXmlToLine(QString xml);
        static void saveClientIp(QString ip, QString autoStart);
        static QStringList getClientIp();
        static void saveCommandList(QStringList data);
        static QStringList getCommandList();
    private:
	
 };


#endif

