/***************************************************************************
 *   Copyright (C) 2007-2009 by Thomas Thelliez <admin.kontrol@gmail.com>  *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as               *
 *   published by the Free Software Foundation; either version 2.0 of      *
 *   the License, or (at your option) any later version.                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU     *
 *   General Public License for more details.                              *
 *                                                                         *
 *   You should have received a copy of the GNU General Public             *
 *   License along with this program; if not, write to                     *
 *   the Free Software Foundation, Inc.,                                   *
 *   51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA          *
 ***************************************************************************/

#include "XmlDataStore.h"

XmlDataStore::XmlDataStore()
{
    #ifdef WIN32
        QDir kpDir(QDir::toNativeSeparators(QDir::homePath()) + "\\KontrolPack");
    #elif defined (linux)
        QDir kpDir(QDir::toNativeSeparators(QDir::homePath()) + "/KontrolPack");
    #elif defined __APPLE__
        QDir kpDir(QDir::toNativeSeparators(QDir::homePath()) + "/KontrolPack");
    #endif
    if (!kpDir.exists())
    {
        QDir dir = QDir::home();
        dir.mkdir("KontrolPack");
        dir.cd("KontrolPack");
        dir.mkdir("Files");
		dir.mkdir("conf");
    }
}

void XmlDataStore::saveFilteredIpsData(QStringList data)
{
    QDomImplementation impl = QDomDocument().implementation();
    QDomDocument doc("filter");
    QDomElement mainNode = doc.createElement("KontrolPack");
    QDomElement ipsListNode = doc.createElement("filteredIpsList");
    for (int j = 0; j < data.size(); ++j) {
        QDomElement ipNode = doc.createElement("ip");
        ipNode.appendChild(doc.createTextNode(data.at(j)));
        ipsListNode.appendChild(ipNode);
    }
    mainNode.appendChild(ipsListNode);
    doc.appendChild(mainNode);
    QString xml = transformXmlToLine(doc.toString()) + "\n";
    QString homePath = QDir::toNativeSeparators(QDir::homePath());
    #ifdef WIN32
        QString path = homePath + "\\KontrolPack\\conf\\KontrolPack-filter.xml";
    #elif defined (linux)
        QString path = homePath + "/KontrolPack/conf/KontrolPack-filter.xml";
    #elif defined __APPLE__
        QString path = homePath + "/KontrolPack/conf/KontrolPack-filter.xml";
    #endif
    QFile file(path);
    if (file.open(QFile::WriteOnly)) {
        QTextStream out(&file);
        out << qPrintable(xml);
        file.close();
    }
}

void XmlDataStore::saveStartUpMode(QString mode)
{
    QDomImplementation impl = QDomDocument().implementation();
    QDomDocument doc("startup");
    QDomElement mainNode = doc.createElement("KontrolPack");
    QDomElement modeNode = doc.createElement("mode");
	modeNode.appendChild(doc.createTextNode(mode));
    mainNode.appendChild(modeNode);
    doc.appendChild(mainNode);
    QString xml = transformXmlToLine(doc.toString()) + "\n";
    QString homePath = QDir::toNativeSeparators(QDir::homePath());
    #ifdef WIN32
        QString path = homePath + "\\KontrolPack\\conf\\KontrolPack-startup-mode.xml";
    #elif defined (linux)
        QString path = homePath + "/KontrolPack/conf/KontrolPack-startup-mode.xml";
    #elif defined __APPLE__
        QString path = homePath + "/KontrolPack/conf/KontrolPack-startup-mode.xml";
    #endif
    QFile file(path);
    if (file.open(QFile::WriteOnly)) {
        QTextStream out(&file);
        out << qPrintable(xml);
        file.close();
    }
}

QString XmlDataStore::getStartUpMode()
{
	QString mode = QString("NONE");
    QString homePath = QDir::toNativeSeparators(QDir::homePath());
    #ifdef WIN32
        QString path = homePath + "\\KontrolPack\\conf\\KontrolPack-startup-mode.xml";
    #elif defined (linux)
        QString path = homePath + "/KontrolPack/conf/KontrolPack-startup-mode.xml";
    #elif defined __APPLE__
        QString path = homePath + "/KontrolPack/conf/KontrolPack-startup-mode.xml";
    #endif
    QFile file(path);
    file.open(QIODevice::ReadOnly | QIODevice::Text);
    QTextStream flow(&file);

    QString line;
    if(!flow.atEnd())
    {
        line = flow.readLine();
    }
    QDomDocument doc;
    doc.setContent(line);
    QDomElement root = doc.documentElement();
    QDomElement child = root.firstChild().toElement();
    while(!child.isNull())
    {
        if (child.tagName() == "mode")
        {
            mode = child.text();
        }
        child = child.nextSibling().toElement();
      }
      return mode;
}

QStringList XmlDataStore::getFilteredIpsData()
{
    QString homePath = QDir::toNativeSeparators(QDir::homePath());
    #ifdef WIN32
        QString path = homePath + "\\KontrolPack\\conf\\KontrolPack-filter.xml";
    #elif defined (linux)
        QString path = homePath + "/KontrolPack/conf/KontrolPack-filter.xml";
    #elif defined __APPLE__
        QString path = homePath + "/KontrolPack/conf/KontrolPack-filter.xml";
    #endif
    QFile file(path);
    file.open(QIODevice::ReadOnly | QIODevice::Text);
    QTextStream flow(&file);

    QString line;
    if(!flow.atEnd())
    {
        line = flow.readLine();
    }
    QStringList ipsList = QStringList();
    QDomDocument doc;
    doc.setContent(line);
    QDomElement root = doc.documentElement();
    QDomElement child = root.firstChild().toElement();
    while(!child.isNull())
    {
        if (child.tagName() == "filteredIpsList")
        {
            QDomElement ipChild = child.firstChild().toElement();
            while(!ipChild.isNull())
            {
                if (ipChild.tagName() == "ip")
                {
                  ipsList.append(ipChild.text());
                }
                ipChild = ipChild.nextSibling().toElement();
            }
        }
        child = child.nextSibling().toElement();
      }
      return ipsList;
}

void XmlDataStore::saveClientIp(QString ipClient, QString autoStart)
{
    QDomImplementation impl = QDomDocument().implementation();
    QDomDocument doc("clientIp");
    QDomElement mainNode = doc.createElement("KontrolPack");
    QDomElement ipNode = doc.createElement("ip");
    QDomElement  autoStartNode = doc.createElement("autoStart");
    ipNode.appendChild(doc.createTextNode(ipClient));
    mainNode.appendChild(ipNode);
    autoStartNode.appendChild(doc.createTextNode(autoStart));
    mainNode.appendChild(autoStartNode);
    doc.appendChild(mainNode);
    QString xml = transformXmlToLine(doc.toString()) + "\n";
    QString homePath = QDir::toNativeSeparators(QDir::homePath());
    #ifdef WIN32
        QString path = homePath + "\\KontrolPack\\conf\\KontrolPack-client-ip.xml";
    #elif defined (linux)
        QString path = homePath + "/KontrolPack/conf/KontrolPack-client-ip.xml";
    #elif defined __APPLE__
        QString path = homePath + "/KontrolPack/conf/KontrolPack-client-ip.xml";
    #endif
    QFile file(path);
    if (file.open(QFile::WriteOnly)) {
        QTextStream out(&file);
        out << qPrintable(xml);
        file.close();
    }
}

QStringList XmlDataStore::getClientIp()
{
    QString ipClientToGet = "";
    QString autoStart = "";
    QString homePath = QDir::toNativeSeparators(QDir::homePath());
    #ifdef WIN32
        QString path = homePath + "\\KontrolPack\\conf\\KontrolPack-client-ip.xml";
    #elif defined (linux)
        QString path = homePath + "/KontrolPack/conf/KontrolPack-client-ip.xml";
    #elif defined __APPLE__
        QString path = homePath + "/KontrolPack/conf/KontrolPack-client-ip.xml";
    #endif
    QFile file(path);
    file.open(QIODevice::ReadOnly | QIODevice::Text);
    QTextStream flow(&file);

    QString line;
    if(!flow.atEnd())
    {
        line = flow.readLine();
    }
    QDomDocument doc;
    doc.setContent(line);
    QDomElement root = doc.documentElement();
    QDomElement child = root.firstChild().toElement();
    while(!child.isNull())
    {
        if (child.tagName() == "ip")
        {
            ipClientToGet = child.text();
        }
        if (child.tagName() == "autoStart")
        {
            autoStart = child.text();
        }
        child = child.nextSibling().toElement();
      }
      QStringList list = QStringList();
      list.append(ipClientToGet);
      list.append(autoStart);
      return list;
}

QStringList XmlDataStore::getCommandList()
{
    QString homePath = QDir::toNativeSeparators(QDir::homePath());
    #ifdef WIN32
        QString path = homePath + "\\KontrolPack\\conf\\KontrolPack-commands-list.xml";
    #elif defined (linux)
        QString path = homePath + "/KontrolPack/conf/KontrolPack-commands-list.xml";
    #elif defined __APPLE__
        QString path = homePath + "/KontrolPack/conf/KontrolPack-commands-list.xml";
    #endif
    QFile file(path);
    file.open(QIODevice::ReadOnly | QIODevice::Text);
    QTextStream flow(&file);

    QString line;
    if(!flow.atEnd())
    {
        line = flow.readLine();
    }
    QStringList commandsList = QStringList();
    QDomDocument doc;
    doc.setContent(line);
    QDomElement root = doc.documentElement();
    QDomElement child = root.firstChild().toElement();
    while(!child.isNull())
    {
        if (child.tagName() == "commandsList")
        {
            QDomElement ipChild = child.firstChild().toElement();
            while(!ipChild.isNull())
            {
                if (ipChild.tagName() == "command")
                {
                  commandsList.append(ipChild.text());
                }
                ipChild = ipChild.nextSibling().toElement();
            }
        }
        child = child.nextSibling().toElement();
      }
      return commandsList;
}

void XmlDataStore::saveCommandList(QStringList data)
{
    QDomImplementation impl = QDomDocument().implementation();
    QDomDocument doc("filter");
    QDomElement mainNode = doc.createElement("KontrolPack");
    QDomElement commandsListNode = doc.createElement("commandsList");
    for (int j = 0; j < data.size(); ++j) {
        QDomElement commandNode = doc.createElement("command");
        commandNode.appendChild(doc.createTextNode(data.at(j)));
        commandsListNode.appendChild(commandNode);
    }
    mainNode.appendChild(commandsListNode);
    doc.appendChild(mainNode);
    QString xml = transformXmlToLine(doc.toString()) + "\n";
    QString homePath = QDir::toNativeSeparators(QDir::homePath());
    #ifdef WIN32
        QString path = homePath + "\\KontrolPack\\conf\\KontrolPack-commands-list.xml";
    #elif defined (linux)
        QString path = homePath + "/KontrolPack/conf/KontrolPack-commands-list.xml";
    #elif defined __APPLE__
        QString path = homePath + "/KontrolPack/conf/KontrolPack-commands-list.xml";
    #endif
    QFile file(path);
    if (file.open(QFile::WriteOnly)) {
        QTextStream out(&file);
        out << qPrintable(xml);
        file.close();
    }
}

QString XmlDataStore::transformXmlToLine(QString xml)
{
    return xml.replace("\n", "");
}
