/***************************************************************************
 *   Copyright (C) 2007-2009 by Thomas Thelliez <admin.kontrol@gmail.com>  *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as               *
 *   published by the Free Software Foundation; either version 2.0 of      *
 *   the License, or (at your option) any later version.                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU     *
 *   General Public License for more details.                              *
 *                                                                         *
 *   You should have received a copy of the GNU General Public             *
 *   License along with this program; if not, write to                     *
 *   the Free Software Foundation, Inc.,                                   *
 *   51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA          *
 ***************************************************************************/

#include "XmlResultsParserClient.h"

XmlResultsParserClient::XmlResultsParserClient()
{
}

QString XmlResultsParserClient::getCommandFromXml(QString buffer)
{
    QString command;
    QDomDocument doc;
    doc.setContent(buffer);
    QDomElement root = doc.documentElement();
    QDomElement child = root.firstChild().toElement();
    while(!child.isNull())
    {
        if (child.tagName() == "command")
        {
          return child.text();
        }
        child = child.nextSibling().toElement();
      }
      return command;
}

QString XmlResultsParserClient::getAskedFileFromXml(QString buffer)
{
    QString fileName;
    QDomDocument doc;
    doc.setContent(buffer);
    QDomElement root = doc.documentElement();
    QDomElement child = root.firstChild().toElement();
    while(!child.isNull())
    {
        if (child.tagName() == FILE_NAME)
        {
          fileName = child.text();
        }
        child = child.nextSibling().toElement();
      }
      return fileName;
}

QStringList XmlResultsParserClient::getFilePathFromXml(QString buffer)
{
    QStringList list = QStringList();
    QDomDocument doc;
    doc.setContent(buffer);
    QDomElement root = doc.documentElement();
    QDomElement child = root.firstChild().toElement();
    while(!child.isNull())
    {
        if (child.tagName() == FILE_NAME)
        {
          list.append(child.text());
        }
        else if (child.tagName() == FILE_SIZE)
        {
          list.append(child.text());
        }
        child = child.nextSibling().toElement();
      }
      return list;
}
