/***************************************************************************
 *   Copyright (C) 2007-2009 by Thomas Thelliez <admin.kontrol@gmail.com>  *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as               *
 *   published by the Free Software Foundation; either version 2.0 of      *
 *   the License, or (at your option) any later version.                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU     *
 *   General Public License for more details.                              *
 *                                                                         *
 *   You should have received a copy of the GNU General Public             *
 *   License along with this program; if not, write to                     *
 *   the Free Software Foundation, Inc.,                                   *
 *   51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA          *
 ***************************************************************************/

#include "XmlCreatorClient.h"

XmlCreatorClient::XmlCreatorClient()
{
}

QString XmlCreatorClient::createXmlParameters(const char *hostname, QString path, QStringList *ipList)
{
    QDomImplementation impl = QDomDocument().implementation();
    QDomDocument doc("parameters");
    QDomElement mainNode = doc.createElement(KONTROLPACK);
    QDomElement hostnameNode = doc.createElement(HOSTNAME);
    QDomElement osNode = doc.createElement(SYSTEM);
    QDomElement fileIndexNode = doc.createElement(FILE_INDEX);
    QDomElement pathNode = doc.createElement(PATH);
    QDomElement fileListNode = doc.createElement(FILE_LIST);
    QDomElement folderListNode = doc.createElement(FOLDER_LIST);
    QDomElement ipListNode = doc.createElement(IP_LIST);
    hostnameNode.appendChild(doc.createTextNode(QString(hostname)));
    #ifdef WIN32
        osNode.appendChild(doc.createTextNode(QString("WINDOWS")));
    #elif defined (linux)
        osNode.appendChild(doc.createTextNode(QString("LINUX")));
    #elif defined __APPLE__
        osNode.appendChild(doc.createTextNode(QString("MACOSX")));
    #endif

    QDir currentDir = QDir(path);

    QStringList foldersList = currentDir.entryList(QDir::Dirs, QDir::Name);
    fileIndexNode.appendChild(doc.createTextNode(QString::number(foldersList.size())));
    QStringList filesList = currentDir.entryList(QDir::Files, QDir::Name);
    for (int j = 0; j < foldersList.size(); ++j) {
        QDomElement folderNode = doc.createElement(FOLDER);
        folderNode.appendChild(doc.createTextNode(foldersList.at(j)));
        folderListNode.appendChild(folderNode);
    }
    for (int j = 0; j < filesList.size(); ++j) {
        QDomElement fileNode = doc.createElement(FILE_XML);
        fileNode.appendChild(doc.createTextNode(filesList.at(j)));
        fileListNode.appendChild(fileNode);
    }
    for (int j = 0; j < ipList->size(); ++j) {
        QDomElement ipNode = doc.createElement(IP);
        ipNode.appendChild(doc.createTextNode(ipList->at(j)));
        ipListNode.appendChild(ipNode);
    }
    mainNode.appendChild(hostnameNode);
    mainNode.appendChild(osNode);
    pathNode.appendChild(doc.createTextNode(QString(path)));
    mainNode.appendChild(pathNode);
    mainNode.appendChild(fileIndexNode);

    mainNode.appendChild(folderListNode);
    mainNode.appendChild(fileListNode);
    mainNode.appendChild(ipListNode);
    doc.appendChild(mainNode);
    return transformXmlToLine(doc.toString());
}

QString XmlCreatorClient::createXmlForFileContext(QString path)
{
    QDomImplementation impl = QDomDocument().implementation();
    QDomDocument doc("contextFile");
    QDomElement mainNode = doc.createElement(KONTROLPACK);
    QDomElement pathNode = doc.createElement(PATH);
    QDomElement fileIndexNode = doc.createElement(FILE_INDEX);
    QDomElement fileListNode = doc.createElement(FILE_LIST);
    QDomElement folderListNode = doc.createElement(FOLDER_LIST);
    QDir currentDir = QDir(path);
    QStringList foldersList = currentDir.entryList(QDir::Dirs, QDir::Name);
    fileIndexNode.appendChild(doc.createTextNode(QString::number(foldersList.size())));
    QStringList filesList = currentDir.entryList(QDir::Files, QDir::Name);
    for (int j = 0; j < foldersList.size(); ++j) {
        QDomElement folderNode = doc.createElement(FOLDER);
        folderNode.appendChild(doc.createTextNode(foldersList.at(j)));
        folderListNode.appendChild(folderNode);
    }
    for (int j = 0; j < filesList.size(); ++j) {
        QDomElement fileNode = doc.createElement(FILE_XML);
        fileNode.appendChild(doc.createTextNode(filesList.at(j)));
        fileListNode.appendChild(fileNode);
    }
    pathNode.appendChild(doc.createTextNode(QString(path)));
    mainNode.appendChild(pathNode);
    mainNode.appendChild(fileIndexNode);
    mainNode.appendChild(folderListNode);
    mainNode.appendChild(fileListNode);
    doc.appendChild(mainNode);
    return transformXmlToLine(doc.toString()) + "\n";
}

QString XmlCreatorClient::createXmlForCommandContext(QString path)
{
    QDomImplementation impl = QDomDocument().implementation();
    QDomDocument doc("context");
    QDomElement mainNode = doc.createElement(KONTROLPACK);
    QDomElement pathNode = doc.createElement(PATH);
    QDomElement fileIndexNode = doc.createElement(FILE_INDEX);
    QDomElement fileListNode = doc.createElement(FILE_LIST);
    QDomElement folderListNode = doc.createElement(FOLDER_LIST);
    QDir currentDir = QDir(path);
    QStringList foldersList = currentDir.entryList(QDir::Dirs, QDir::Name);
    fileIndexNode.appendChild(doc.createTextNode(QString::number(foldersList.size())));
    QStringList filesList = currentDir.entryList(QDir::Files, QDir::Name);
    for (int j = 0; j < foldersList.size(); ++j) {
        QDomElement folderNode = doc.createElement(FOLDER);
        folderNode.appendChild(doc.createTextNode(foldersList.at(j)));
        folderListNode.appendChild(folderNode);
    }
    for (int j = 0; j < filesList.size(); ++j) {
        QDomElement fileNode = doc.createElement(FILE_XML);
        fileNode.appendChild(doc.createTextNode(filesList.at(j)));
        fileListNode.appendChild(fileNode);
    }
    pathNode.appendChild(doc.createTextNode(QString(path)));
    mainNode.appendChild(pathNode);
    mainNode.appendChild(fileIndexNode);
    mainNode.appendChild(folderListNode);
    mainNode.appendChild(fileListNode);
    doc.appendChild(mainNode);
    qDebug(qPrintable("XML : " + transformXmlToLine(doc.toString()) + "\n"));
    return transformXmlToLine(doc.toString()) + "\n";
}

QString XmlCreatorClient::createXmlToTellServerFileTransfertDoneFlow(QString file)
{
    QDomImplementation impl = QDomDocument().implementation();
    QDomDocument doc("fileTransfered");
    QDomElement mainNode = doc.createElement(KONTROLPACK);
    QDomElement filePathNode = doc.createElement(FILE_PATH);
    filePathNode.appendChild(doc.createTextNode(file));
    mainNode.appendChild(filePathNode);
    doc.appendChild(mainNode);
    return transformXmlToLine(doc.toString()) + "\n";
}

QString XmlCreatorClient::createXmlToSendFileFlow(QString buffer, int fileSize, bool readable)
{
    QDomImplementation impl = QDomDocument().implementation();
    QDomDocument doc("fileAsked");
    QDomElement mainNode = doc.createElement(KONTROLPACK);
    QDomElement filePathNode = doc.createElement(FILE_NAME);
    QDomElement fileSizeNode = doc.createElement(FILE_SIZE);
    QDomElement readableFileNode = doc.createElement(READABLE);
    filePathNode.appendChild(doc.createTextNode(buffer));
    fileSizeNode.appendChild(doc.createTextNode(QString::number(fileSize)));
    readableFileNode.appendChild(doc.createTextNode(QString(readable ? "true" : "false")));
    mainNode.appendChild(filePathNode);
    mainNode.appendChild(fileSizeNode);
    mainNode.appendChild(readableFileNode);
    doc.appendChild(mainNode);
    return transformXmlToLine(doc.toString()) + "\n";
}

QString XmlCreatorClient::transformXmlToLine(QString xml)
{
    return xml.replace(QString("\n"), QString(""));
}
