/***************************************************************************
 *   Copyright (C) 2005 by Daniel Stöckel                                  *
 *   the_docter@gmx.net                                                    *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/
#include "menu.h"

#include <math.h>

#include "commandobutton.h"
#include "configuration.h"

Menu::Menu(Menu* parentMenu, const QString& appName)
    : QButtonGroup(),mParentMenu(parentMenu),mSelectedButtonNum(BUTTON_DESELECT),mAppName(appName)
{
    children.setAutoDelete(true);
}

Menu::~Menu()
{
    for(int i=0;i<count();++i)
    {
        QButton* temp = find(i);
        remove(temp);
        delete temp;
    }
}

void Menu::showButtons( )
{
    for(int i=0;i<count();++i)
    {
        find(i)->show();
    }
}

void Menu::hideButtons( )
{
    for(int i=0;i<count();++i)
    {
        find(i)->hide();
    }
}

void Menu::arrangeButtons( )
{
    RoundButton* button;
    Config& config = Config::getSingleton();
    unsigned int dist= config.buttonDistance();
    double step=2*M_PI/static_cast<double>(count());

    for(int i=0;i<count();++i){
        button=static_cast<RoundButton*>(find(i));
        //God bless sine and cosine
        button->move(static_cast<int>(sin(i*step)*dist+config.menuRadius()),
                     static_cast<int>(-cos(i*step)*dist+config.menuRadius()));
    }

    for(Menu* it = children.first(); it != 0; it = children.next()){
        it->arrangeButtons();
    }
}

void Menu::selectButton( int num )
{
    if(mSelectedButtonNum>=0){
        static_cast<RoundButton*>(find(mSelectedButtonNum))->setActive(false);
    }
    if(num!=BUTTON_DESELECT){
        int newButton;
        if((newButton=num%count())<0){
            //if newButton is a negative value we have to get a positve value congruent newButton mod count() :)
            newButton=count()+newButton;
        }
        mSelectedButtonNum=newButton;
        RoundButton* temp=  static_cast<RoundButton*>(find(mSelectedButtonNum));
        temp->setActive(true);
        emit buttonSelected(temp->type());
    } else {
        mSelectedButtonNum = BUTTON_DESELECT;
        emit buttonSelected(0);
    }
}

QButton * Menu::selectedButton( )
{
    if(mSelectedButtonNum<0){
        return NULL;
    }
    return find(mSelectedButtonNum);
}

int Menu::insert( QButton * button, int id )
{
    RoundButton* rButton = static_cast<RoundButton*>(button);
    connect(rButton, SIGNAL(mouseIn(RoundButton*)),this,SLOT(slotMouseIn(RoundButton*)));
    connect(rButton, SIGNAL(mouseOut(RoundButton*)),this,SLOT(slotMouseOut()));

    if(rButton->type() == RoundButton::Submenu){
        children.append(static_cast<SubmenuButton*>(rButton)->subMenu());
    }

    return QButtonGroup::insert(button,id);
}

int Menu::insertNoChild( QButton * button, int id )
{
    RoundButton* rButton = static_cast<RoundButton*>(button);
    connect(rButton, SIGNAL(mouseIn(RoundButton*)),this,SLOT(slotMouseIn(RoundButton*)));
    connect(rButton, SIGNAL(mouseOut(RoundButton*)),this,SLOT(slotMouseOut()));

    return QButtonGroup::insert(button,id);
}

void Menu::slotMouseIn(RoundButton* emitter)
{
    selectButton(emitter);
}

void Menu::slotMouseOut()
{
    selectButton(BUTTON_DESELECT);
}

Menu * Menu::execute( )
{
    if(selectedButtonNum()!=BUTTON_DESELECT){
        CommandoButton* temp = static_cast<CommandoButton*>(selectedButton());
        selectButton(BUTTON_DESELECT);
        return temp->execute();
    }
    return 0;    //Well, we shouldn't actually reach this place, as execute is only called if it is sure that a button was selected
}

void Menu::selectButton( QButton * button )
{
    selectButton(id(button));
}

#include "menu.moc"
