/*
    This file is part of KolabAdmin.

    Copyright (C) 2006 Tobias Koenig <tobias.koenig@credativ.de>

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
*/

#include <QCheckBox>
#include <QLabel>

#include "servicesfield.h"

using namespace Form;

ServicesField::ServicesField( const QString &name, QWidget *parent )
  : Field( name, parent )
{
  QWidget *widget = new QWidget( this );

  QGridLayout *layout = new QGridLayout( widget );
  layout->setMargin( 0 );

  mPOP = new QCheckBox( widget );
  mPOPS = new QCheckBox( widget );
  mIMAP = new QCheckBox( widget );
  mIMAPS = new QCheckBox( widget );
  mSieve = new QCheckBox( widget );
  mFTP = new QCheckBox( widget );
  mHTTP = new QCheckBox( widget );
  mAmavis = new QCheckBox( widget );

  layout->addWidget( new QLabel( tr( "POP3 Service" ), widget ), 0, 0 );
  layout->addWidget( mPOP, 0, 1, 1, 2, Qt::AlignRight );
  layout->addWidget( new QLabel( tr( "POP3/SSL Service (TCP port 995)" ), widget ), 1, 0 );
  layout->addWidget( mPOPS, 1, 1, 1, 2, Qt::AlignRight );
  layout->addWidget( new QLabel( tr( "IMAP Service" ), widget ), 2, 0 );
  layout->addWidget( mIMAP, 2, 1, 1, 2, Qt::AlignRight );
  layout->addWidget( new QLabel( tr( "IMAP/SSL Service (TCP port 993)" ), widget ), 3, 0 );
  layout->addWidget( mIMAPS, 3, 1, 1, 2, Qt::AlignRight );
  layout->addWidget( new QLabel( tr( "Sieve Service (TCP port 2000)" ), widget ), 4, 0 );
  layout->addWidget( mSieve, 4, 1, 1, 2, Qt::AlignRight );
  layout->addWidget( new QLabel( tr( "FTP FreeBusy Service (Legacy, not interoperable with Kolab2 FreeBusy)" ), widget ), 5, 0 );
  layout->addWidget( mFTP, 5, 1, 1, 2, Qt::AlignRight );
  layout->addWidget( new QLabel( tr( "HTTP FreeBusy Service (Legacy)" ), widget ), 6, 0 );
  layout->addWidget( mHTTP, 6, 1, 1, 2, Qt::AlignRight );
  layout->addWidget( new QLabel( tr( "Amavis Email Scanning (Virus/Spam)" ), widget ), 7, 0 );
  layout->addWidget( mAmavis, 7, 1, 1, 2, Qt::AlignRight );

  fieldLayout()->addWidget( widget, 0, 0 );
}

void ServicesField::loadEntry( const Entry &entry )
{
  mPOP->setChecked( entry.value( "cyrus-pop3" ) == "TRUE" );
  mPOPS->setChecked( entry.value( "cyrus-pop3s" ) == "TRUE" );
  mIMAP->setChecked( entry.value( "cyrus-imap" ) == "TRUE" );
  mIMAPS->setChecked( entry.value( "cyrus-imaps" ) == "TRUE" );
  mSieve->setChecked( entry.value( "cyrus-sieve" ) == "TRUE" );
  mFTP->setChecked( entry.value( "proftpd-ftp" ) == "TRUE" );
  mHTTP->setChecked( entry.value( "apache-http" ) == "TRUE" );
  mAmavis->setChecked( entry.value( "postfix-enable-virus-scan" ) == "TRUE" );
}

void ServicesField::saveEntry( Entry &entry ) const
{
  entry.setValue( "cyrus-pop3", mPOP->isChecked() ? "TRUE" : "FALSE" );
  entry.setValue( "cyrus-pop3s", mPOPS->isChecked() ? "TRUE" : "FALSE" );
  entry.setValue( "cyrus-imap", mIMAP->isChecked() ? "TRUE" : "FALSE" );
  entry.setValue( "cyrus-imaps", mIMAPS->isChecked() ? "TRUE" : "FALSE" );
  entry.setValue( "cyrus-sieve", mSieve->isChecked() ? "TRUE" : "FALSE" );
  entry.setValue( "proftpd-ftp", mFTP->isChecked() ? "TRUE" : "FALSE" );
  entry.setValue( "apache-http", mHTTP->isChecked() ? "TRUE" : "FALSE" );
  entry.setValue( "postfix-enable-virus-scan", mAmavis->isChecked() ? "TRUE" : "FALSE" );
}

bool ServicesField::isValid( QString&, PagePolicy::State ) const
{
  return true;
}

void ServicesField::setEditable( bool editable )
{
  mPOP->setEnabled( editable );
  mPOPS->setEnabled( editable );
  mIMAP->setEnabled( editable );
  mIMAPS->setEnabled( editable );
  mSieve->setEnabled( editable );
  mFTP->setEnabled( editable );
  mHTTP->setEnabled( editable );
  mAmavis->setEnabled( editable );
}

