<?php
/**
 * class for ajax functions that return xml
 *
 * @package Knowledgeroot
 * @author Frank Habermann
 * @version $Id: class-ajax-xml.php 356 2007-04-22 13:02:35Z lordlamer $
 */
class ajax_xml {
	// global array with classes
	var $CLASS = array();

	// var with xmlcode to return
	var $xmlcode = "";

	/**
	 * init/start class
	 */
	function start(&$CLASS) {
		$this->CLASS =& $CLASS;
	}

	/**
	 * check what to do
	 */
	function check_vars() {
		//check if userid and groupid is set, if not set to 0
		if($_SESSION['userid'] == "" || $_SESSION['groupid'] == "") {
			$_SESSION['userid'] = 0;
			$_SESSION['groupid'] = 0;
		}

		// try to work only with POST
		if (isset ($_POST['ajaxopen']) and $_POST['ajaxopen'] != "") {
			$this->tree_open($_POST['ajaxopen']);
		} elseif (isset ($_POST['ajaxclose']) and $_POST['ajaxclose'] != "") {
			$this->tree_close($_POST['ajaxclose']);
		} elseif (isset ($_POST['reloadtree']) and $_POST['reloadtree'] != "") {
			$this->tree_reload();
		} elseif (isset ($_POST['expandtree']) and $_POST['expandtree'] != "") {
			$this->tree_expand();
		} elseif (isset ($_POST['collapsetree']) and $_POST['collapsetree'] != "") {
			$this->tree_collapse();
		}
	}

	/**
	 * generate xml to open tree part
	 */
	function tree_open($id) {
		// get all elements to open
		$elements = $this->getOpenTreeElements($id);

		// generate xmloutput
		$this->xmlcode = '<?xml version="1.0" ?>' . "\n";
		$this->xmlcode .= "<root>\n";
		$this->xmlcode .= "\t<parentid>".$id."</parentid>\n";
		$this->xmlcode .= "\t<html>\n";
		$this->xmlcode .= "<![CDATA[\n";
		//$this->xmlcode .= htmlentities($elements);
		$this->xmlcode .= $elements;
		$this->xmlcode .= "]]>\n";
		$this->xmlcode .= "\t</html>\n";
		$this->xmlcode .= "</root>\n";

		// save tree status to session and to db
		$_SESSION['open'][$id] = 1;

		if(!empty($_SESSION['userid'])) {
			$res = $this->CLASS['db']->query(sprintf("UPDATE users SET treecache='%s' WHERE id=%d",serialize($_SESSION['open']),$_SESSION['userid']));
		}
	}

	/**
	 * generate xml to close treepart
	 */
	function tree_close($id) {
		// get all elements to close
		$elements = $this->getCloseTreeElements($id);

		// generate xmloutput
		$this->xmlcode = '<?xml version="1.0" ?>' . "\n";
		$this->xmlcode .= "<root>\n";
		$this->xmlcode .= $elements;
		$this->xmlcode .= "</root>\n";

		// save tree status to session and to db
		$_SESSION['open'][$id] = 0;

		if(!empty($_SESSION['userid'])) {
			$res = $this->CLASS['db']->query(sprintf("UPDATE users SET treecache='%s' WHERE id=%d",serialize($_SESSION['open']),$_SESSION['userid']));
		}
	}

	/**
	 * returns elements to close of an treeparentelement
	 */
	function getCloseTreeElements($id) {
		// check if the user have permissions
		if($this->CLASS['knowledgeroot']->checkRecursivPerm($id, $_SESSION['userid']) != 0) {
			if(isset($_SESSION['admin']) and $_SESSION['admin'] == 1) {
				$query = sprintf("SELECT id FROM tree WHERE belongs_to=%d AND deleted=0 ORDER BY title ASC",$id);
			} else {
				// get groups from user
				$res = $this->CLASS['db']->query(sprintf("SELECT groupid FROM user_group WHERE userid=%d",$_SESSION['userid']));
				$orclause = "";
				while($rowuser = $this->CLASS['db']->fetch_assoc($res)) {
					if($this->CLASS['db']->dbtype == "pgsql") {
						$orclause .= sprintf("OR (\"group\"=%d  AND grouprights > 0) ",$rowuser['groupid']);
					} else {
						$orclause .= sprintf("OR (`group`=%d  AND grouprights > 0) ",$rowuser['groupid']);
					}
				}

				if($this->CLASS['db']->dbtype == "pgsql") {
					$query = sprintf("SELECT id FROM tree WHERE belongs_to=%d AND deleted=0 AND ((otherrights > 0) OR (\"group\"=%d AND grouprights > 0) %sOR (owner=%d AND userrights>0)) ORDER BY title ASC",$id,$_SESSION['groupid'],$orclause,$_SESSION['userid']);
				} else {
					$query = sprintf("SELECT id FROM tree WHERE belongs_to=%d AND deleted=0 AND ((otherrights > 0) OR (`group`=%d AND grouprights > 0) %sOR (owner=%d AND userrights>0)) ORDER BY title ASC",$id,$_SESSION['groupid'],$orclause,$_SESSION['userid']);
				}
			}

			$line = "";
			$line .= $this->getCloseContentElements($id);
			
			// get all elements to close in tree
			$res = $this->CLASS['db']->query($query);
			while($row = $this->CLASS['db']->fetch_assoc($res)) {
				$line .= "<element>".$row['id']."</element>\n";
				
				// get content elements to close
				$line .= $this->getCloseContentElements($row['id']);

				// try to get childs of this element
				if(isset($_SESSION['open'][$row['id']]) && $_SESSION['open'][$row['id']] == 1) {
					$line .= $this->getCloseTreeElements($row['id']);
				}
			}
		}

		return $line;
	}

	/**
	 *
	 */
	function getCloseContentElements($pageid) {
		$out = "";
		
		// select the content in table content with userrights
		if (isset ($_SESSION['admin']) and $_SESSION['admin'] == 1) {
			if($this->CLASS['db']->dbtype == "pgsql") {
				$query = sprintf("SELECT ct.id as id, ct.content as content, ct.title as title, ct.type as type, u.name as lastupdatedby, to_char(ct.lastupdated,'DD. Mon YYYY HH24:MI:SS') as lastupdated FROM content ct left outer join users u ON ct.lastupdatedby = u.id WHERE belongs_to=%d AND ct.deleted=0 ORDER BY ct.sorting ASC",$pageid);
			} else {
				$query = "SELECT ct.id AS id, ct.content AS content, ct.title AS title, ct.type AS type, u.name AS lastupdatedby, DATE_FORMAT(ct.lastupdated,'%d. %M %Y %H:%i:%s') as lastupdated FROM content ct";
				$query .= sprintf(" LEFT OUTER JOIN users u ON ct.lastupdatedby = u.id WHERE belongs_to=%d AND ct.deleted=0 ORDER BY ct.sorting ASC", $pageid);
			}
		} else {
			// get groups from user
			$res = $this->CLASS['db']->query(sprintf("SELECT groupid FROM user_group WHERE userid=%d",$_SESSION['userid']));
			$orclause = "";
			while($rowuser = $this->CLASS['db']->fetch_assoc($res)) {
				if($this->CLASS['db']->dbtype == "pgsql") {
					$orclause .= sprintf("OR (ct.\"group\"=%d  AND ct.grouprights > 0) ",$rowuser['groupid']);
				} else {
					$orclause .= sprintf("OR (ct.`group`=%d  AND ct.grouprights > 0) ",$rowuser['groupid']);
				}
			}
	
			if($this->CLASS['db']->dbtype == "pgsql") {
				$query = sprintf("SELECT ct.id as id, ct.content as content, ct.title as title, ct.type as type, u.name as lastupdatedby, to_char(ct.lastupdated,'DD. Mon YYYY HH24:MI:SS') as lastupdated FROM content ct left outer join users u ON ct.lastupdatedby = u.id WHERE belongs_to=%d AND ct.deleted=0 AND ((ct.otherrights > 0) OR (ct.\"group\"=%d AND ct.grouprights > 0) %sOR (ct.owner=%d AND ct.userrights>0)) ORDER BY ct.sorting ASC",$pageid,$_SESSION['groupid'],$orclause,$_SESSION['userid']);
			} else {
				$query = "SELECT ct.id AS id, ct.content AS content, ct.title AS title, ct.type AS type, u.name AS lastupdatedby, DATE_FORMAT(ct.lastupdated,'%d. %M %Y %H:%i:%s') AS lastupdated FROM content ct";
				$query .= sprintf(" LEFT OUTER JOIN users u ON ct.lastupdatedby = u.id WHERE belongs_to=%d AND ct.deleted=0 AND ((ct.otherrights > 0) OR (ct.`group`=%d AND ct.grouprights > 0) %s OR (ct.owner=%d AND ct.userrights>0)) ORDER BY ct.sorting ASC",
				$pageid, $_SESSION['groupid'], $orclause,$_SESSION['userid']);
			}
		}

		$res = $this->CLASS['db']->query($query);
		
		while($row = $this->CLASS['db']->fetch_assoc($res)) {
			$out .= "<content>".$row['id']."</content>\n";
		}
		
		return $out;
	}
	
	/**
	 * returns elements to open in tree
	 */
	function getOpenTreeElements($id) {
		$this->CLASS['tree'] = new categoryTree();

		// check if page is movingpage
		if($_POST['move'] == "1") {
			$this->CLASS['tree']->start($this->CLASS,'move',"#");
		} else if (isset ($_POST['editor']) && $_POST['editor'] == "1") {
			$this->CLASS['tree']->start($this->CLASS,'editor',"#");
		} else {
			$this->CLASS['tree']->start($this->CLASS);
		}

		$lines = $this->CLASS['tree']->buildAjaxTreePart($id);

		return $lines;
	}

	/**
	 * return xmlcode
	 */
	function get_xml() {
		return $this->xmlcode;
	}

	/**
	 * returns the hole tree for reloading
	 */
	function tree_reload($expand = "") {
		$this->CLASS['tree'] = new categoryTree();

		// check if page is movingpage
		if(isset($_POST['move']) && $_POST['move'] == "1") {
			$this->CLASS['tree']->start($this->CLASS,'move',"#");
		} else if (isset ($_POST['editor']) && $_POST['editor'] == "1") {
			$this->CLASS['tree']->start($this->CLASS,'editor',"#");
		} else {
			$this->CLASS['tree']->start($this->CLASS);
		}

		if($expand != "") {
			$this->CLASS['tree']->doexpand = $expand;
			$this->CLASS['tree']->expand = $expand;
		}

		$lines = $this->CLASS['tree']->buildAjaxTreePart("0");

		// generate tree
		$tree = "<table id=\"treeelementtable\" class=\"treeelements\" cellpadding=\"0\" cellspacing=\"0\" border=\"0\" width=\"100%\">\n";
		$tree .= $lines;
		$tree .= "</table>\n";

		// generate xmloutput
		$this->xmlcode = '<?xml version="1.0" ?>' . "\n";
		$this->xmlcode .= "<root>\n";
		$this->xmlcode .= "\t<html>\n";
		$this->xmlcode .= "<![CDATA[\n";
		$this->xmlcode .= $tree;
		$this->xmlcode .= "]]>\n";
		$this->xmlcode .= "\t</html>\n";
		$this->xmlcode .= "</root>\n";
	}

	/**
	 * expand tree
	 */
	function tree_expand() {
		$_SESSION['firstrun'] = 0;

		if (isset($_SESSION['open']) && $_SESSION['open'] != null) {
			foreach($_SESSION['open'] as $key => $value) {
				$_SESSION['open'][$key] = 1;
			}
		}

		// save treecache
		if(!empty($_SESSION['userid'])) {
			$res = $this->CLASS['db']->query(sprintf("UPDATE users SET treecache='%s' WHERE id=%d",serialize($_SESSION['open']),$_SESSION['userid']));
		}

		$this->tree_reload("1");
	}

	/**
	 * collapse tree
	 */
	function tree_collapse() {
		$_SESSION['firstrun'] = 0;

		if (isset($_SESSION['open']) && $_SESSION['open'] != null) {
			foreach($_SESSION['open'] as $key => $value) {
				$_SESSION['open'][$key] = 0;
			}
		}

		// save treecache
		if(!empty($_SESSION['userid'])) {
			$res = $this->CLASS['db']->query(sprintf("UPDATE users SET treecache='%s' WHERE id=%d",serialize($_SESSION['open']),$_SESSION['userid']));
		}

		$this->tree_reload();
	}
}
?>