/***************************************************************************
                          setpageservers.h  -  description
                             -------------------
    begin                : Thu Aug 16 2001
    copyright            : (C) 2003 by Troy Corbin Jr.
    email                : tcorbin@users.sourceforge.net
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef SETPAGESERVERS_H
#define SETPAGESERVERS_H

#include <qtabwidget.h>
#include <kbuttonbox.h>
#include <klistview.h>
#include <klineedit.h>
#include <kcombobox.h>
#include <qlabel.h>
#include <qhbox.h>
#include <qstringlist.h>
#include <qcheckbox.h>
#include <qwidget.h>
#include <qgroupbox.h>
#include <qpushbutton.h>
#include <qcheckbox.h>
#include <qspinbox.h>
#include <qlist.h>
#include <qlayout.h>
#include "resource.h"
#include "dlg_server.h"

/**
  *@author Troy Corbin Jr.
  */

class setPageServers : public QVBoxLayout
{
   Q_OBJECT
	public:
						setPageServers(QWidget *parent=0, resource *Rsrc=0);
						~setPageServers();
		bool		resetServer;

	public slots:
		void									slotServer_Add( void );
		void									slotServer_Modify( void );
		void									slotServer_Delete( void );

		void									slotCurrent( int );

		void									slot_Premove( bool );
		void									slot_Private( bool );
		void									slot_Profanity( int );
		void									slot_Kibitz( bool );
		void									slot_Tell( bool );
		void									slot_Shout( bool );
		void									slot_Seek( bool );
		void									slot_SeekTimer( int value );
		void									slot_Auto_Close_ICS( bool state );

	signals:
		void									enableApply( void );

	protected slots:
		void									BuildServerData( void );
		void									selectionChanged( void );

	protected:
		void									initTab1( void );
		void									initTab2( void );

	private:
		resource							*Resource;
		int										margin;
		QTabWidget						*TabParent;
		
													/* Tab 1 : Servers */
		QVBox									*Tab1;
			QGroupBox							*GROUP_Current;
			QGroupBox							*GROUP_Servers;
			KComboBox							*Servers;
			KListView							*Servers_ListView;
			KButtonBox						*Servers_ButtonBox;
				QPushButton					*Servers_Button_Add;
				QPushButton					*Servers_Button_Change;
				QPushButton					*Servers_Button_Delete;
			dlg_server						*Server_Dialog;
													/* Tab 2 : Options */
		QVBox									*Tab2;
			QGroupBox							*BOX_Profanity;
				KComboBox							*COMBO_Profanity;
			QCheckBox							*BUTTON_Premove;
			QCheckBox							*BUTTON_Private;
			QCheckBox							*BUTTON_Kibitz;
			QCheckBox							*BUTTON_Tell;
			QCheckBox							*BUTTON_Shout;
			QCheckBox							*BUTTON_Seek;
			QCheckBox							*BUTTON_Auto_Close_ICS;
			QHBox									*BOX_SeekTimer;
				QSpinBox							*BUTTON_SeekTimer;
				QLabel								*LABEL_SeekTimer;
};

#endif
