#! /bin/bash

#
# This little script creates the main .po file 
# to take as pattern for translations. 
# use msgmerge to merge the new with the old translation file
#
# 23. Sept. 2000, encounter7@gmx.net
#
# modified a little to do all po files - jade 2001
# 21 June 2001 - jade
#              - added some error checking and nice printout :)
#              - doesnt update itself
#
echo "Creating Updated po files for knapster2"
echo "--------------------------------------------------------"

echo "deleting old knapster.po ..."
rm -f knapster2.po tmp.po
touch knapster2.po

echo "creating new knapster.po ..."
find ../knapster2 -name "*.cpp" -exec xgettext -LC++ -ki18n -j -dknapster2 -s -p../po {} \; 

pofiles=`ls *.po`

updatedfiles=""
# only the ones that we arent getting regular updates to and the ones encounter is doing :)
# pofiles=da.po de.po hu.po ja.pt_BR.po sv.po

for i in $pofiles; do
  if [ "$i" != "knapster2.po" ]; then  
    echo -n "updating $i ..."
    msgmerge $i knapster2.po -o tmp.po
    mv -f tmp.po $i

    updatedfiles="$updatedfiles $i"
  fi
done
echo "--------------------------------------------------------"
if [ "$updatedfiles" != "" ]; then
  echo -en "you should adjust the files:\n$updatedfiles\nwith ktranslator or kbabel\n\n"
else
  echo "No po files to update"
fi

