
#ifndef EZSOCKET_H

#define EZSOCKET_H

#ifndef __WIN32__
 #include <netinet/in.h>
#else
 #include <windows.h>
 #include <string>
 #include <winsock.h>
#endif

/**
 * @short simple TCP socket implementation
 * @author John Donoghue
 * @version 0.2
 * @date 8-12-2000
 *
 * Provides a basic c++ implementation of the TCP socket
 * functionality for creating a TCP server and clients.
 * that will work transparently between UNIX and Windows 
 */
class EZSocket
{
   private:
      /** 
       * the socket handle 
       */
      int sock;
      /**
       * the destinatation socket address
       */
      struct sockaddr_in sockin;
      /**
       * the src socket address
       */
      struct sockaddr_in srcsockin;

      /**
       * flag for whether this socket is a server or a
       * client
       */
      bool isserver;
      // if winsock was required and loaded
      bool load_winsock;

   public:
      // HACK DONE -----------------------------
      EZSocket(int s,bool isserv)
      {
        sock = s;
	isserver = isserv;
	load_winsock = false;
      }
      
      /**
       * create the server listener
       *
       * @param _port the port to listen on
       * @exception EZNoConnectionException
       */
      EZSocket(int port);
      // accept();
      // listen();

      /**
       * create the a socket for  
       *
       * @param _port the port to listen on !!!!!!!!?????????????????
       * @exception EZNoConnectionException
       */ 
      EZSocket(const char *_ip,int _port); 

      /**
       * deconstructor - removes the socket
       */
      ~EZSocket();

      /**
       * get the opened listen sock
       * will return -1 in the case that it is not open 
       */
      int getSocket() { return sock; }


      int writeText(char *text);
      
      /**
       * write specified data through the socket
       *
       * @param _buffer the buffer to write data from
       * @param _sz the number of bytes to write from the buffer
       *
       * @return the number of bytes written - may be negative in the case of an
       * error
       */
      int writeData(void *_buffer,unsigned long _sz);

      /**
       * read specified data drom socket
       *
       * @param _buffer the buffer to read data to
       * @param _sz the number of bytes to read to the buffer
       *
       * @return the number of byes read
       */
      int readData(void *_buffer,unsigned long _sz);

      /**
       * peek specified data from socket without actually removing it from
       * the queue
       *
       * @param _buffer the buffer to read data to
       * @param _sz the number of bytes to read to the buffer
       *
       * @return the number of byes read
       */
      int peekData(void *_buffer,unsigned long _sz);

      /**
       * get the full specified data from the socket
       * This function will not return until the number of bytes is read or an
       * error occurs
       *
       * @param _buffer the buffer to read data to
       * @param _sz the number of bytes to read to the buffer
       *
       * @returns the number of bytes read or in the case of an error, this will
       * be less
       */
      int getFullData(void *_buffer,unsigned long _sz);

      /**
       * check whether there is data available on the read socket
       *
       * @return true if there is data waiting
       */
      bool hasData();

      /**
       * wait for data on the socket - will not return until there is data or an
       * error occurs
       *
       * @return true is there is data, false on an error
       */
      bool waitData();

      /**
       * wait up to x micoseconds for data to be come availble
       * @param _usec max microseconds to wait.
       * @return true if data bcomes available
       */
      bool waitTimeData(long _usec);

      /**
       * returns the current address of the server comunications.
       * For a client, this will be the address it is writing to,
       * for a server, this will be the last client that was read from, or
       * INADDR_ANY if none has been read.
       */
      unsigned long getDstIPAddress();

      /**
       * return the port thatwe are sending data to
       *
       * @returns the port we are connected to
       */
      int getDstPort();

      /**
       * returns the current address of the server comunications.
       * For a server, this will be the last client that was read from, or
       * INADDR_ANY if none has been read.
       */
      unsigned long getSrcIPAddress();

      /**
       * return the port that we recieved data from
       *
       * @returns the port number that we recieved data from
       */
      int getSrcPort();

      /**
       * clear the socket of pending data to be read
       */
      void clear();
      /**
       * wait and connect to an incomin connection
       * on this socket
       * if it is not a server socket the will return 0
       */
      EZSocket *waitConnection();

     
   protected:
      /**
       * create a socket class from existing information
       * only used internally by waitConnection()
       */
      EZSocket(int _sock,struct sockaddr_in srcsockin);
      
      /**
       * lookup an ip number or host name and return the long encoded value of it
       *
       * private function called by constructors only
       *
       * @param _ip the string containing the ip number or host name to connect
       * to
       *
       * @return INADDR_ANY if invalid address, otherwise the ip as a long.
       */
      unsigned long lookupAddress(const char *_ip);

      /**
       * open a socket on a specified port
       *
       * private function called only by constructors
       *
       * @param _port the port to connect to
       * @param _addr the encoded address to connect - if this is INADDR_ANY then
       * this will be a server connection
       *
       * @exception EZNoConnectionException
       */
      void openSocket(int _port,unsigned long _addr=INADDR_ANY);

      /**
       * close opened socket
       *
       * private function called only by deconstructor
       *
       */
      void closeSocket();

      // functio that will open winsock if required
      bool openWinSock();

      /* dont allow people to copy us */
      EZSocket(const EZSocket &) {}

      /* dont allow people to assign references to us */
      EZSocket& operator=(const EZSocket &) { return *this; }
};

#endif // EZSOCKET_H
