/***************************************************************************
 $RCSfile$
                             -------------------
    cvs         : $Id: kbanking.h 401 2007-01-15 22:13:48Z martin $
    begin       : Mon Mar 01 2004
    copyright   : (C) 2004 by Martin Preuss
    email       : martin@libchipcard.de

 ***************************************************************************
 *          Please see toplevel file COPYING for license details           *
 ***************************************************************************/

#ifndef KBANKING_KBANKING_H
#define KBANKING_KBANKING_H

#include <aqbanking/version.h>
#include <aqbanking/banking.h>
#include <qbanking/qbanking.h>

#ifndef AQB_MAKE_VERSION
  #define AQB_MAKE_VERSION(a,b,c,d) (((a)<<24) | ((b)<<16) | (c<<8) | (d))
#endif

#ifndef AQBANKING_VERSION
  #define AQBANKING_VERSION AQB_MAKE_VERSION(AQBANKING_VERSION_MAJOR,AQBANKING_VERSION_MINOR,AQBANKING_VERSION_PATCHLEVEL,AQBANKING_VERSION_BUILD)
#endif

#ifndef AQB_IS_VERSION
  #define AQB_IS_VERSION(a,b,c,d) (AQBANKING_VERSION >= AQB_MAKE_VERSION(a,b,c,d))
#endif

#ifndef KBANKING_GUIID
  #if AQB_IS_VERSION(3,9,0,0)
    #define onlineInit() onlineInit(0)
    #define onlineFini() onlineFini(0)
    #define AB_BANKING_GETACCOUNTBYALIAS(a, b) AB_Banking_GetAccountByAlias(a, b, 0)
  #else
    #define AB_BANKING_GETACCOUNTBYALIAS(a, b) AB_Banking_GetAccountByAlias(a, b)
  #endif
#endif


#include <list>


class KBanking: public QBanking {
private:
  AB_JOB_LIST2 *_jobQueue;

public:
  KBanking(const char *appname,
           const char *cfgDir=0);
  virtual ~KBanking();

  int init();
  int fini();

  int executeQueue(AB_IMEXPORTER_CONTEXT *ctx);

  int enqueueJob(AB_JOB *j);
  int dequeueJob(AB_JOB *j);
  std::list<AB_JOB*> getEnqueuedJobs();

};




#endif /* KBANKING_KBANKING_H */


