/***************************************************************************
 begin                : Thu Sep 5 2002
 copyright            : (C) 2002 by Christian Hubinger
 email                : chubinger@irrsinnig.org
***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef KMFPROCOUT_H
#define KMFPROCOUT_H

// QT includes
#include <qwidget.h>
#include <qstring.h>
#include <qpixmap.h>

// KDE includes
#include <kprocess.h>

/**
  *@author Christian Hubinger
  */

class QLabel;
class QGridLayout;
class KPushButton;
class QTextBrowser;
namespace KMF {
class KDE_EXPORT KMFProcOut : public QWidget {
	Q_OBJECT
public:
	KMFProcOut( QWidget *parent = 0, const char *name = 0, WFlags fl = 0 );
	~KMFProcOut();

	bool isRunning();
	void runCmd( const QString& cmd, const QString& job_name, const QString& job_description, bool useKdeSu );
	void setText( const QString&, const QString& coomandName);

public slots:
	void slotKillJob();
	
protected slots:
	void slotReceivedOutput( KProcess*, char*, int );
	void slotReceivedError( KProcess*, char*, int );
	void slotProcessExited( KProcess* );

private:
	
	void startJob(  const QString &dir, bool useKdeSu );
	// void prepareJob( const QString &dir );
	void childFinished( bool normal, int status );
	void insertStderrLine( const QString &line );
	void insertStdoutLine( const QString &line );
	void slotSetButtons();
	void initGUI();

private:    // data
	QString* stderrbuf;
	QString* stdoutbuf;
	KProcess* childproc;
	
	QPixmap icon_stop, icon_close;
	QString m_job_name;
	QTextBrowser *m_lbview;
	QLabel *m_ljob_name;
	QGridLayout *m_layout;
	KPushButton *m_bkill;

signals:
	void processExited( KProcess * );
	void rowSelected( int row );
	void sigJobFinished( bool, const QString& );
};
}
#endif
