/***************************************************************************
   begin                : Thu Apr 17 2003
   copyright            : (C) 2003 by Christian Hubinger
   email                : chubinger@irrsinnig.org
***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include "kapplication.h"
#include "kmfnewdocdlg.h"
#include "../version.h"
#include "kmfnewdocdlg.moc"

// QT includes
#include "qpixmap.h"
#include "qpainter.h"
#include "qlabel.h"
#include "qstring.h"
#include "qpushbutton.h"
#include "qrect.h"


// KDE includes
#include "kstandarddirs.h"
#include "kdebug.h"
namespace KMF {
KMFNewDocDlg::KMFNewDocDlg( QWidget *parent, const char *name, WFlags fl ) : KMyFirewallNewDocument( parent, name, fl ) {
	KStandardDirs std_dir;
	QString dir = std_dir.findResource( "data", "kmyfirewall/pics/splash_cut.png" );
	kdDebug() << "Found Splashscreen at: " << dir << endl;

	QPixmap pic = QPixmap::fromMimeSource( dir );
	QFont f( "helvetica", 8, QFont::Bold );
	if ( pic.isNull() )
		return ;
	QPainter p( &pic );
	p.setFont( f );
	p.setPen( Qt::white );
	p.drawText( 165, 45, QString( "Version %1" ).arg( KMYFIREWALL_VERSION ) );
	p.drawText( 93, 215, QString( "%1" ).arg( COPYRIGHT_DATE ) );
	p.drawText( 70, 230, QString( "%1" ).arg( COPYRIGHT_OWNER ) );
	if ( pic.isNull() )
		return ;
	l_pic->setPixmap( pic );
	connect( b_cancel, SIGNAL( clicked() ), this, SLOT( reject() ) );
	connect( b_close, SIGNAL( clicked() ), this, SLOT( reject() ) );
	connect( b_empty, SIGNAL( clicked() ), this, SLOT( loadEmpty() ) );
	connect( b_template, SIGNAL( clicked() ), this, SLOT( loadTemplate() ) );
	connect( b_load_saved, SIGNAL( clicked() ), this, SLOT( loadSaved() ) );
	connect( b_help, SIGNAL( clicked() ), this, SLOT( slotHelp() ) );
	QRect screen = QApplication::desktop() ->screenGeometry();
	QRect mainRect;
	screen = QApplication::desktop() ->screenGeometry( QApplication::desktop() ->screenNumber( mainRect.center() ) );
	move( screen.center() - QPoint( width() / 2, height() / 2 ) );
}

KMFNewDocDlg::~KMFNewDocDlg() {}



void KMFNewDocDlg::reject() {
	close();
}

void KMFNewDocDlg::loadEmpty() {
	hide();
	emit sigNewDocLoadEmpty();
	close();
}
void KMFNewDocDlg::loadWizard() {
	hide();
	emit sigNewDocLoadWizard();
	close();
}
void KMFNewDocDlg::loadTemplate() {
	hide();
	emit sigNewDocLoadTemplate();
	close();
}
void KMFNewDocDlg::loadSaved() {
	hide();
	emit sigNewDocLoadSaved();
	close();
}
void KMFNewDocDlg::slotHelp() {
	kapp->invokeHelp();
}

}
